/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.BaseKieServicesClientTest;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.credentials.EnteredTokenCredentialsProvider;

public class KieServicesClientTest
extends BaseKieServicesClientTest {
    private static final String CONTAINER_ID = "mycontainer";
    private static final String ARTIFACT_ID = "myproject";
    private static final String GROUP_ID = "org.kie";
    private static final String VERSION = "1.2.3";

    @Test
    public void testGetServerInfo() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)VERSION, (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testListContainers() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"List of created containers\">\n  <kie-containers>\n    <kie-container container-id=\"kjar1\" status=\"FAILED\"/>\n    <kie-container container-id=\"kjar2\" status=\"FAILED\"/>  </kie-containers></response>")));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.listContainers();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Number of listed containers", (long)2L, (long)((KieContainerResourceList)response.getResult()).getContainers().size());
    }

    @Test
    public void testCreateContainer() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        WireMock.stubFor((MappingBuilder)WireMock.put((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers/kie1")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(201).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Container successfully deployed\">\n  <kie-container container-id=\"kie1\" status=\"STARTED\">\n    <release-id>\n      <group-id>org.kie.server.testing</group-id>\n      <artifact-id>kjar2</artifact-id>\n      <version>1.0-SNAPSHOT</version>\n    </release-id>\n    <resolved-release-id>\n      <group-id>org.kie.server.testing</group-id>\n      <artifact-id>kjar2</artifact-id>\n      <version>1.0-SNAPSHOT</version>\n    </resolved-release-id>\n  </kie-container>\n</response>")));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ReleaseId releaseId = new ReleaseId("org.kie.server.testing", "kjar2", "1.0-SNAPSHOT");
        KieContainerResource resource = new KieContainerResource("kie1", releaseId);
        ServiceResponse response = client.createContainer("kie1", resource);
        this.assertSuccess(response);
        KieContainerResource container = (KieContainerResource)response.getResult();
        Assert.assertEquals((String)"Container id", (Object)"kie1", (Object)container.getContainerId());
        Assert.assertEquals((String)"Release id", (Object)releaseId, (Object)container.getReleaseId());
        Assert.assertEquals((String)"Resolved release Id", (Object)releaseId, (Object)container.getResolvedReleaseId());
    }

    @Test
    public void testGetServerInfoWithSingletonExtraClass() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/json")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("{\n  \"type\" : \"SUCCESS\",\n  \"msg\" : \"Kie Server info\",\n  \"result\" : {\n    \"kie-server-info\" : {\n      \"version\" : \"1.2.3\"\n    }\n  }\n}")));
        this.config.setMarshallingFormat(MarshallingFormat.JSON);
        this.config.setExtraClasses(Collections.singleton(KieContainerStatus.class));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)VERSION, (Object)((KieServerInfo)response.getResult()).getVersion());
    }

    @Test
    public void testGetServerInfoBasicAuth() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)VERSION, (Object)((KieServerInfo)response.getResult()).getVersion());
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Authorization", WireMock.equalTo((String)"Basic bnVsbDpudWxs")));
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.getRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Authorization", WireMock.equalTo((String)"Bearer abcdefghijk")));
    }

    @Test
    public void testGetServerInfoTokenAuth() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        this.config.setCredentialsProvider((CredentialsProvider)new EnteredTokenCredentialsProvider("abcdefghijk"));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)VERSION, (Object)((KieServerInfo)response.getResult()).getVersion());
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Authorization", WireMock.equalTo((String)"Bearer abcdefghijk")));
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.getRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Authorization", WireMock.equalTo((String)"Basic bnVsbDpudWxs")));
    }

    @Test
    public void testAdditionalHeaderViaClient() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Kie Server info\">\n  <kie-server-info>\n    <version>1.2.3</version>\n  </kie-server-info>\n</response>")));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-KIE-First-Header", "first-value");
        headers.put("X-KIE-Second-Header", "second value");
        this.config.setHeaders(headers);
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getServerInfo();
        this.assertSuccess(response);
        Assert.assertEquals((String)"Server version", (Object)VERSION, (Object)((KieServerInfo)response.getResult()).getVersion());
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("X-KIE-First-Header", WireMock.equalTo((String)"first-value")));
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/")).withHeader("X-KIE-Second-Header", WireMock.equalTo((String)"second value")));
    }

    @Test
    public void testGetReleaseId() {
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/containers/mycontainer/release-id")).withHeader("Accept", WireMock.equalTo((String)"application/xml")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/xml").withBody("<response type=\"SUCCESS\" msg=\"Release ID for mycontainer\">\n  <release-id>\n    <artifact-id>myproject</artifact-id>\n    <group-id>org.kie</group-id>\n    <version>1.2.3</version>\n  </release-id>\n</response>")));
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.config);
        ServiceResponse response = client.getReleaseId(CONTAINER_ID);
        this.assertSuccess(response);
        ReleaseId releaseId = (ReleaseId)response.getResult();
        Assert.assertNotNull((Object)releaseId);
        Assert.assertEquals((String)"Artifact ID", (Object)ARTIFACT_ID, (Object)releaseId.getArtifactId());
        Assert.assertEquals((String)"Group ID", (Object)GROUP_ID, (Object)releaseId.getGroupId());
        Assert.assertEquals((String)"Version", (Object)VERSION, (Object)releaseId.getVersion());
    }

    private void assertSuccess(ServiceResponse<?> response) {
        Assert.assertEquals((String)"Response type", (Object)KieServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
    }
}

