/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class UIServicesClientImpl
extends AbstractKieServicesClientImpl
implements UIServicesClient {
    public UIServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public UIServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public String getProcessForm(String containerId, String processId, String language) {
        return this.getProcessFormByType(containerId, processId, language, "ANY");
    }

    @Override
    public String getProcessFormByType(String containerId, String processId, String language, String formType) {
        return this.getProcessFormByType(containerId, processId, language, formType, true);
    }

    @Override
    public String getProcessRawForm(String containerId, String processId) {
        return this.getProcessFormByType(containerId, processId, null, "ANY", false);
    }

    @Override
    public String getProcessForm(String containerId, String processId) {
        return this.getProcessFormByType(containerId, processId, "ANY");
    }

    @Override
    public String getProcessFormByType(String containerId, String processId, String formType) {
        return this.getProcessFormByType(containerId, processId, null, formType, true);
    }

    private String getProcessFormByType(String containerId, String processId, String language, String formType, boolean marshallContent) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            StringBuffer params = new StringBuffer();
            params.append("type=").append(formType);
            params.append("&marshallContent=").append(marshallContent);
            boolean filter = false;
            if (!StringUtils.isEmpty((CharSequence)language)) {
                params.append("&lang=").append(language);
                filter = true;
            }
            params.append("&filter=").append(filter);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/forms/processes/{pId}", valuesMap) + "?" + params.toString());
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayProcess", new Object[]{containerId, processId, StringUtils.defaultString((String)language), !StringUtils.isEmpty((CharSequence)language), formType})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String getTaskForm(String containerId, Long taskId, String language) {
        return this.getTaskFormByType(containerId, taskId, language, "ANY");
    }

    @Override
    public String getTaskFormByType(String containerId, Long taskId, String language, String formType) {
        return this.getTaskFormByType(containerId, taskId, language, formType, true);
    }

    private String getTaskFormByType(String containerId, Long taskId, String language, String formType, boolean marshallContent) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            StringBuffer params = new StringBuffer();
            params.append("type=").append(formType);
            params.append("&marshallContent=").append(marshallContent);
            boolean filter = false;
            if (!StringUtils.isEmpty((CharSequence)language)) {
                params.append("&lang=").append(language);
                filter = true;
            }
            params.append("&filter=").append(filter);
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/forms/tasks/{tInstanceId}", valuesMap) + "?" + params.toString());
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("FormService", "getFormDisplayTask", new Object[]{containerId, taskId, StringUtils.defaultString((String)language), !StringUtils.isEmpty((CharSequence)language), formType})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String getTaskForm(String containerId, Long taskId) {
        return this.getTaskFormByType(containerId, taskId, "ANY");
    }

    @Override
    public String getTaskFormByType(String containerId, Long taskId, String formType) {
        return this.getTaskFormByType(containerId, taskId, null, formType, true);
    }

    @Override
    public String getTaskRawForm(String containerId, Long taskId) {
        return this.getTaskFormByType(containerId, taskId, null, "ANY", false);
    }

    @Override
    public String getProcessImage(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/svg+xml");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/images/processes/{pId}", valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ImageService", "getProcessImage", new Object[]{containerId, processId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }

    @Override
    public String getProcessInstanceImage(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/svg+xml");
            return this.makeHttpGetRequestAndCreateRawResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"containers/{id}/images/processes/instances/{pInstanceId}", valuesMap), headers);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("ImageService", "getActiveProcessImage", new Object[]{containerId, processInstanceId})));
        ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM-UI", containerId).getResponses().get(0);
        this.throwExceptionOnFailure(response);
        if (this.shouldReturnWithNullResponse(response)) {
            return null;
        }
        return (String)response.getResult();
    }
}

