/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.kie.server.controller.rest.ControllerUtils;

public class ConcurrentModificationExceptionTest {
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();
    private static final String serverTemplateId = "id";

    @Before
    public void setUp() {
        ServerTemplate serverTemplate = new ServerTemplate(serverTemplateId, "name");
        IntStream.range(0, 1000).boxed().map(i -> Integer.toString(i)).map(s -> new ServerInstanceKey(s, s, s, "")).forEach(instance -> serverTemplate.addServerInstance(instance));
        this.templateStorage.store(serverTemplate);
    }

    private void disconnect() {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        try {
            for (ServerInstanceKey instanceKey : serverTemplate.getServerInstanceKeys()) {
                serverTemplate.deleteServerInstance(instanceKey.getServerInstanceId());
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConcurrency() {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        ControllerUtils.marshal((String)"application/xml", (Object)serverTemplate);
        Thread disconnect = new Thread(() -> this.disconnect());
        disconnect.start();
        String response = ControllerUtils.marshal((String)"application/xml", (Object)serverTemplate);
        Assert.assertNotNull((Object)response);
    }
}

