/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.logging.Logger;
import org.kie.server.router.ConfigurationListener;
import org.kie.server.router.ContainerInfo;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.FailedHostInfo;

public class Configuration {
    private static final Logger log = Logger.getLogger(Configuration.class);
    private Map<String, List<String>> hostsPerServer = new ConcurrentHashMap<String, List<String>>();
    private Map<String, List<String>> hostsPerContainer = new ConcurrentHashMap<String, List<String>>();
    private Map<String, List<ContainerInfo>> containerInfosPerContainer = new ConcurrentHashMap<String, List<ContainerInfo>>();
    private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();

    public Map<String, List<String>> getHostsPerServer() {
        return this.hostsPerServer;
    }

    public Map<String, List<String>> getHostsPerContainer() {
        return this.hostsPerContainer;
    }

    public Map<String, List<ContainerInfo>> getContainerInfosPerContainer() {
        return this.containerInfosPerContainer;
    }

    public void addContainerHost(String containerId, String serverUrl) {
        List<String> hosts = this.hostsPerContainer.get(containerId);
        if (hosts == null) {
            hosts = new ArrayList<String>();
            this.hostsPerContainer.put(containerId, hosts);
        }
        hosts.add(serverUrl);
        this.listeners.forEach(l -> l.onContainerAdded(containerId, serverUrl));
    }

    public void addServerHost(String serverId, String serverUrl) {
        List<String> hosts = this.hostsPerServer.get(serverId);
        if (hosts == null) {
            hosts = new ArrayList<String>();
            this.hostsPerServer.put(serverId, hosts);
        }
        hosts.add(serverUrl);
        this.listeners.forEach(l -> l.onServerAdded(serverId, serverUrl));
    }

    public void addContainerInfo(ContainerInfo containerInfo) {
        List<ContainerInfo> containersByAlias = this.containerInfosPerContainer.get(containerInfo.getAlias());
        if (containersByAlias == null) {
            containersByAlias = new ArrayList<ContainerInfo>();
            this.containerInfosPerContainer.put(containerInfo.getAlias(), containersByAlias);
        }
        containersByAlias.add(containerInfo);
        List<ContainerInfo> containersById = this.containerInfosPerContainer.get(containerInfo.getContainerId());
        if (containersById == null) {
            containersById = new ArrayList<ContainerInfo>();
            this.containerInfosPerContainer.put(containerInfo.getContainerId(), containersById);
        }
        containersById.add(containerInfo);
    }

    public void removeContainerHost(String containerId, String serverUrl) {
        List<String> hosts = this.hostsPerContainer.get(containerId);
        if (hosts != null) {
            hosts.remove(serverUrl);
        }
        this.listeners.forEach(l -> l.onContainerRemoved(containerId, serverUrl));
    }

    public void removeServerHost(String serverId, String serverUrl) {
        List<String> hosts = this.hostsPerServer.get(serverId);
        if (hosts != null) {
            hosts.remove(serverUrl);
        }
        this.listeners.forEach(l -> l.onServerRemoved(serverId, serverUrl));
    }

    public void removeContainerInfo(ContainerInfo containerInfo) {
        List<ContainerInfo> containersByAlias;
        List<ContainerInfo> containersById = this.containerInfosPerContainer.get(containerInfo.getContainerId());
        if (containersById == null) {
            log.warn("Container info with id '" + containerInfo.getContainerId() + "' is not found, nothing is removed.");
            return;
        }
        containersById.remove(containerInfo);
        List hosts = this.hostsPerContainer.getOrDefault(containerInfo.getContainerId(), Collections.emptyList());
        if (hosts.isEmpty()) {
            this.containerInfosPerContainer.remove(containerInfo.getContainerId());
        }
        if ((containersByAlias = this.containerInfosPerContainer.get(containerInfo.getAlias())) != null) {
            containersByAlias.remove(containerInfo);
            hosts = this.hostsPerContainer.getOrDefault(containerInfo.getAlias(), Collections.emptyList());
            if (hosts.isEmpty()) {
                this.containerInfosPerContainer.remove(containerInfo.getAlias());
            }
        }
    }

    public synchronized FailedHostInfo removeUnavailableServer(String requestURL) {
        String serverUrl = null;
        String serverId = null;
        block0: for (Map.Entry<String, List<String>> entry : this.hostsPerServer.entrySet()) {
            List<String> list = entry.getValue();
            for (String host : list) {
                if (!requestURL.startsWith(host)) continue;
                serverUrl = host;
                serverId = entry.getKey();
                continue block0;
            }
        }
        if (serverId != null && serverUrl != null) {
            this.removeServerHost(serverId, serverUrl);
        }
        HashSet<String> containers = new HashSet<String>();
        for (Map.Entry<String, List<String>> entry : this.hostsPerContainer.entrySet()) {
            List<String> hosts = entry.getValue();
            for (String host : hosts) {
                if (!requestURL.startsWith(host)) continue;
                serverUrl = host;
                containers.add(entry.getKey());
            }
        }
        if (!containers.isEmpty()) {
            String string = serverUrl;
            containers.forEach(container -> this.removeContainerHost((String)container, actualServerUrl));
        }
        FailedHostInfo failedHostInfo = new FailedHostInfo(serverId, serverUrl, containers);
        return failedHostInfo;
    }

    public void addListener(ConfigurationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "{hostsPerServer=" + this.hostsPerServer + ", hostsPerContainer=" + this.hostsPerContainer + "}";
    }

    public void addEmptyContainerHost(String containerId) {
        List<String> hosts = this.hostsPerContainer.get(containerId);
        if (hosts == null) {
            hosts = new ArrayList<String>();
            this.hostsPerContainer.put(containerId, hosts);
        }
    }

    public void addEmptyServerHost(String serverId) {
        List<String> hosts = this.hostsPerServer.get(serverId);
        if (hosts == null) {
            hosts = new ArrayList<String>();
            this.hostsPerServer.put(serverId, hosts);
        }
    }

    public synchronized void reloadFrom(Configuration updated) {
        this.containerInfosPerContainer = updated.getContainerInfosPerContainer();
        this.hostsPerServer.keySet().forEach(server -> {
            if (!updated.hostsPerServer.containsKey(server)) {
                ArrayList serverUrls = new ArrayList(this.hostsPerServer.remove(server));
                serverUrls.forEach(url -> this.removeServerHost((String)server, (String)url));
            }
        });
        this.hostsPerContainer.keySet().forEach(container -> {
            if (!updated.hostsPerContainer.containsKey(container)) {
                ArrayList serverUrls = new ArrayList(this.hostsPerContainer.remove(container));
                serverUrls.forEach(url -> this.removeContainerHost((String)container, (String)url));
            }
        });
        this.hostsPerServer.keySet().forEach(server -> {
            ArrayList serverUrls = new ArrayList(this.hostsPerServer.get(server));
            List<String> updatedServerUrls = updated.hostsPerServer.remove(server);
            for (String serverUrl : serverUrls) {
                if (updatedServerUrls.contains(serverUrl)) {
                    updatedServerUrls.remove(serverUrl);
                    continue;
                }
                this.removeServerHost((String)server, serverUrl);
            }
            updatedServerUrls.forEach(url -> this.addServerHost((String)server, (String)url));
        });
        this.hostsPerContainer.keySet().forEach(container -> {
            ArrayList serverUrls = new ArrayList(this.hostsPerContainer.get(container));
            List<String> updatedServerUrls = updated.hostsPerContainer.remove(container);
            for (String serverUrl : serverUrls) {
                if (updatedServerUrls.contains(serverUrl)) {
                    updatedServerUrls.remove(serverUrl);
                    continue;
                }
                this.removeContainerHost((String)container, serverUrl);
            }
            updatedServerUrls.forEach(url -> this.addContainerHost((String)container, (String)url));
        });
        updated.hostsPerServer.forEach((server, urls) -> urls.forEach(url -> this.addServerHost((String)server, (String)url)));
        updated.hostsPerContainer.forEach((container, urls) -> urls.forEach(url -> this.addContainerHost((String)container, (String)url)));
        this.listeners.forEach(l -> l.onConfigurationReloaded());
    }

    public synchronized void reloadFromRepository(ConfigRepository repository) {
        Configuration loaded = repository.load();
        this.containerInfosPerContainer = loaded.getContainerInfosPerContainer();
        this.hostsPerContainer = loaded.getHostsPerContainer();
        this.hostsPerServer = loaded.getHostsPerServer();
    }
}

