/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.kie.server.router.Configuration;
import org.kie.server.router.KieServerRouter;
import org.kie.server.router.repository.ConfigurationMarshaller;

public class ConfigFileWatcher
implements Runnable {
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private long sleepTime = Long.parseLong(System.getProperty("org.kie.server.router.config.watcher.interval", "30000"));
    private Path toWatch;
    private AtomicBoolean active = new AtomicBoolean(true);
    private ConfigurationMarshaller marshaller;
    private Configuration configuration;
    private long lastUpdate = -1L;

    public ConfigFileWatcher(String configFilePath, ConfigurationMarshaller marshaller, Configuration configuration) {
        this.marshaller = marshaller;
        this.configuration = configuration;
        this.toWatch = Paths.get(configFilePath, new String[0]);
        if (!Files.isDirectory(this.toWatch, new LinkOption[0])) {
            this.toWatch = Paths.get(configFilePath, new String[0]).getParent();
        }
        this.toWatch = Paths.get(this.toWatch.toString(), "kie-server-router.json");
        try {
            this.lastUpdate = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            log.error((Object)"Unable to read last modified date of routers config file", e);
        }
    }

    public void stop() {
        this.active.set(false);
    }

    @Override
    public void run() {
        try {
            while (this.active.get()) {
                FileTime lastModified = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]);
                log.debug("Config file " + this.toWatch + " last modified " + lastModified);
                if (lastModified.toMillis() > this.lastUpdate) {
                    log.debug("Config file updated, reloading...");
                    try (FileReader reader = new FileReader(this.toWatch.toFile());){
                        Configuration updated = this.marshaller.unmarshall(reader);
                        this.configuration.reloadFrom(updated);
                    }
                    catch (Exception e) {
                        log.error((Object)("Unexpected exception while reading updated configuration file :: " + e.getMessage()), e);
                    }
                    this.lastUpdate = lastModified.toMillis();
                }
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted exception received...");
        }
        catch (IOException e1) {
            log.warn((Object)"Unexpected exception while watching config file", e1);
        }
    }
}

