/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn.pmml;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.dmn.pmml.DMNPMMLTrustyKieServerBaseIntegrationTest;

public class DMNPMMLTrustyRegressionIntegrationTest
extends DMNPMMLTrustyKieServerBaseIntegrationTest {
    private static final String REGRESSION_MODEL_NAMESPACE = "https://kiegroup.org/dmn/_51A1FD67-8A67-4332-9889-B718BE8B7456";
    private static final String REGRESSION_MODEL_NAME = "TestRegressionDMN";
    private static final String REGRESSION_DECISION_NAME = "Decision";
    private static final Object EXPECTED_RESULT = new BigDecimal("52.5");
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 300000L;
    private static final String MODEL_BASE = "regression";
    private static final String CONTAINER_ID_COMPILED = "regression-compiled";
    private static final String ARTIFACT_ID_COMPILED = "dmn-pmml-trusty-regression-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/dmn-pmml-trusty-regression-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "regression-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "dmn-pmml-trusty-regression-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/dmn-pmml-trusty-regression-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        DMNPMMLTrustyRegressionIntegrationTest.setup(RESOURCE_COMPILED, 300000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        DMNPMMLTrustyRegressionIntegrationTest.setup(RESOURCE_NOT_COMPILED, 300000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyDmnPmmlRegressionModelCompiled() {
        this.execute(CONTAINER_ID_COMPILED, REGRESSION_MODEL_NAMESPACE, REGRESSION_MODEL_NAME, REGRESSION_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyDmnPmmlRegressionModelNotCompiled() {
        this.execute(CONTAINER_ID_NOT_COMPILED, REGRESSION_MODEL_NAMESPACE, REGRESSION_MODEL_NAME, REGRESSION_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
        INPUT_DATA.put("fld1", 3);
        INPUT_DATA.put("fld2", 2);
        INPUT_DATA.put("fld3", "y");
    }
}

