/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn.pmml;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.dmn.pmml.DMNPMMLTrustyKieServerBaseIntegrationTest;

public class DMNPMMLTrustyScorecardIntegrationTest
extends DMNPMMLTrustyKieServerBaseIntegrationTest {
    private static final String SCORECARD_MODEL_NAMESPACE = "http://www.trisotech.com/definitions/_ca466dbe-20b4-4e88-a43f-4ce3aff26e4f";
    private static final String SCORECARD_MODEL_NAME = "KiePMMLScoreCard";
    private static final String SCORECARD_DECISION_NAME = "my decision";
    private static final Object EXPECTED_RESULT = new BigDecimal("41.345");
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 300000L;
    private static final String MODEL_BASE = "scorecard";
    private static final String CONTAINER_ID_COMPILED = "scorecard-compiled";
    private static final String ARTIFACT_ID_COMPILED = "dmn-pmml-trusty-scorecard-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/dmn-pmml-trusty-scorecard-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "scorecard-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "dmn-pmml-trusty-scorecard-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/dmn-pmml-trusty-scorecard-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        DMNPMMLTrustyScorecardIntegrationTest.setup(RESOURCE_COMPILED, 300000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        DMNPMMLTrustyScorecardIntegrationTest.setup(RESOURCE_NOT_COMPILED, 300000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyDmnPmmlScorecardModelCompiled() {
        this.execute(CONTAINER_ID_COMPILED, SCORECARD_MODEL_NAMESPACE, SCORECARD_MODEL_NAME, SCORECARD_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyDmnPmmlScorecardModelNotCompiled() {
        this.execute(CONTAINER_ID_NOT_COMPILED, SCORECARD_MODEL_NAMESPACE, SCORECARD_MODEL_NAME, SCORECARD_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
    }
}

