/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn.pmml;

import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.dmn.pmml.DMNPMMLTrustyKieServerBaseIntegrationTest;

public class DMNPMMLTrustyTreeIntegrationTest
extends DMNPMMLTrustyKieServerBaseIntegrationTest {
    private static final String TREE_MODEL_NAMESPACE = "https://kiegroup.org/dmn/_FAA4232D-9D61-4089-BB05-5F5D7C1AECE1";
    private static final String TREE_MODEL_NAME = "TestTreeDMN";
    private static final String TREE_DECISION_NAME = "Decision";
    private static final Object EXPECTED_RESULT = "sunglasses";
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 300000L;
    private static final String MODEL_BASE = "tree";
    private static final String CONTAINER_ID_COMPILED = "tree-compiled";
    private static final String ARTIFACT_ID_COMPILED = "dmn-pmml-trusty-tree-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/dmn-pmml-trusty-tree-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "tree-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "dmn-pmml-trusty-tree-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/dmn-pmml-trusty-tree-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        DMNPMMLTrustyTreeIntegrationTest.setup(RESOURCE_COMPILED, 300000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        DMNPMMLTrustyTreeIntegrationTest.setup(RESOURCE_NOT_COMPILED, 300000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyDmnPmmlTreeModelCompiled() {
        this.execute(CONTAINER_ID_COMPILED, TREE_MODEL_NAMESPACE, TREE_MODEL_NAME, TREE_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyDmnPmmlTreeModelNotCompiled() {
        this.execute(CONTAINER_ID_NOT_COMPILED, TREE_MODEL_NAMESPACE, TREE_MODEL_NAME, TREE_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
        INPUT_DATA.put("temperature", 30);
        INPUT_DATA.put("humidity", 10);
    }
}

