/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn.pmml;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.kie.api.KieServices;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.DMNServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.basetests.RestJmsSharedBaseIntegrationTest;

public abstract class DMNPMMLTrustyKieServerBaseIntegrationTest
extends RestJmsSharedBaseIntegrationTest {
    protected static final String TEST_GROUP = "org.kie.server.testing.dmn.pmml-trusty";
    protected static final String TEST_VERSION = "1.0.0.Final";
    protected static final String DMN_PMML_TRUSTY_PREFIX = "dmn-pmml-trusty-";
    protected static final String COMPILED_SUFFIX = "-compiled";
    protected static final String NOT_COMPILED_SUFFIX = "-not-compiled";
    protected static final String KJAR_SOURCES_PREFIX = "/kjars-sources/";
    protected DMNServicesClient dmnClient;

    public static void setup(String resourceDir, long extendedTimeout, String containerId, ReleaseId releaseId) {
        commandsFactory = KieServices.Factory.get().getCommands();
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)resourceDir);
        KieServicesClient client = DMNPMMLTrustyKieServerBaseIntegrationTest.createDefaultStaticClient((long)extendedTimeout);
        ServiceResponse reply = client.createContainer(containerId, new KieContainerResource(containerId, releaseId));
        KieServerAssert.assertSuccess((ServiceResponse)reply);
    }

    protected void execute(String containerId, String pmmlModelNameSpace, String pmmlModelName, String pmmlDecisionName, Object expectedResult, Map<String, Object> inputData) {
        DMNContext dmnContext = this.dmnClient.newContext();
        inputData.forEach((arg_0, arg_1) -> ((DMNContext)dmnContext).set(arg_0, arg_1));
        ServiceResponse serviceResponse = this.dmnClient.evaluateDecisionByName(containerId, pmmlModelNameSpace, pmmlModelName, pmmlDecisionName, dmnContext);
        Assertions.assertThat((Comparable)serviceResponse.getType()).isEqualTo((Object)KieServiceResponse.ResponseType.SUCCESS);
        DMNResult dmnResult = (DMNResult)serviceResponse.getResult();
        Assertions.assertThat((Object)dmnResult).isNotNull();
        Assertions.assertThat((boolean)dmnResult.hasErrors()).isFalse();
        Object result = dmnResult.getDecisionResultByName(pmmlDecisionName).getResult();
        Assertions.assertThat((Object)result).isEqualTo(expectedResult);
    }

    protected void setupClients(KieServicesClient kieServicesClient) {
        this.dmnClient = (DMNServicesClient)kieServicesClient.getServicesClient(DMNServicesClient.class);
    }
}

