/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn.pmml;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.dmn.pmml.DMNPMMLTrustyKieServerBaseIntegrationTest;

public class DMNPMMLTrustyMiningIntegrationTest
extends DMNPMMLTrustyKieServerBaseIntegrationTest {
    private static final String MINING_MODEL_NAMESPACE = "https://kiegroup.org/dmn/_0E8EC382-BB89-4877-8D37-A59B64285F05";
    private static final String MINING_MODEL_NAME = "MiningModelDMN";
    private static final String MINING_DECISION_NAME = "Decision";
    private static final Object EXPECTED_RESULT = new BigDecimal("-299");
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 300000L;
    private static final String MODEL_BASE = "mining";
    private static final String CONTAINER_ID_COMPILED = "mining-compiled";
    private static final String ARTIFACT_ID_COMPILED = "dmn-pmml-trusty-mining-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/dmn-pmml-trusty-mining-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "mining-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "dmn-pmml-trusty-mining-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/dmn-pmml-trusty-mining-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        DMNPMMLTrustyMiningIntegrationTest.setup(RESOURCE_COMPILED, 300000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        DMNPMMLTrustyMiningIntegrationTest.setup(RESOURCE_NOT_COMPILED, 300000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyDmnPmmlMiningModelCompiled() {
        this.execute(CONTAINER_ID_COMPILED, MINING_MODEL_NAMESPACE, MINING_MODEL_NAME, MINING_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyDmnPmmlMiningModelNotCompiled() {
        this.execute(CONTAINER_ID_NOT_COMPILED, MINING_MODEL_NAMESPACE, MINING_MODEL_NAME, MINING_DECISION_NAME, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.dmn.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
        INPUT_DATA.put("input1", 200);
        INPUT_DATA.put("input2", -1);
        INPUT_DATA.put("input3", 2);
    }
}

