/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.dmn;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.integrationtests.dmn.DMNKieServerBaseIntegrationTest;
import org.kie.server.integrationtests.shared.KieServerDeployer;

public class DMNInputDataStringIntegrationTest
extends DMNKieServerBaseIntegrationTest {
    private static final org.kie.server.api.model.ReleaseId kjar1 = new org.kie.server.api.model.ReleaseId("org.kie.server.testing", "input-data-string", "1.0.0.Final");
    private static final String CONTAINER_1_ID = "input-data-string";

    @BeforeClass
    public static void deployArtifacts() {
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProject((String)ClassLoader.class.getResource("/kjars-sources/input-data-string").getFile());
        kieContainer = KieServices.Factory.get().newKieContainer((ReleaseId)kjar1);
        DMNInputDataStringIntegrationTest.createContainer((String)CONTAINER_1_ID, (org.kie.server.api.model.ReleaseId)kjar1);
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    @Test
    public void test_evaluateAllDecisions() {
        DMNContext dmnContext = this.dmnClient.newContext();
        dmnContext.set("Full Name", (Object)"John Doe");
        ServiceResponse evaluateAllDecisions = this.dmnClient.evaluateAllDecisions(CONTAINER_1_ID, dmnContext);
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)evaluateAllDecisions.getType());
        DMNResult dmnResult = (DMNResult)evaluateAllDecisions.getResult();
        Assert.assertThat((Object)dmnResult.getDecisionResults().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("Greeting Message").getResult(), (Matcher)Matchers.is((Object)"Hello John Doe"));
        DMNContext result = dmnResult.getContext();
        Assert.assertThat((Object)result.get("Greeting Message"), (Matcher)Matchers.is((Object)"Hello John Doe"));
    }
}

