/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.pmml;

import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.pmml.PMMLApplyModelBaseTest;

public class ApplyMiningModelIntegrationTest
extends PMMLApplyModelBaseTest {
    private static final String CORRELATION_ID = "123";
    private static final String MODEL_NAME = "MixedMining";
    private static final String FILE_NAME = "MiningModelMixed.pmml";
    private static final String TARGET_FIELD = "categoricalResult";
    private static final Object EXPECTED_RESULT = 2.3724999999999987;
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 90000000L;
    private static final String MODEL_BASE = "mining";
    private static final String CONTAINER_ID_COMPILED = "mining-compiled";
    private static final String ARTIFACT_ID_COMPILED = "pmml-trusty-mining-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/pmml-trusty-mining-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "mining-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "pmml-trusty-mining-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/pmml-trusty-mining-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        ApplyMiningModelIntegrationTest.setup(RESOURCE_COMPILED, 90000000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        ApplyMiningModelIntegrationTest.setup(RESOURCE_NOT_COMPILED, 90000000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyPmmlMiningModelCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyPmmlMiningModelNotCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_NOT_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
        INPUT_DATA.put("categoricalX", "red");
        INPUT_DATA.put("categoricalY", "classA");
        INPUT_DATA.put("age", 25.0);
        INPUT_DATA.put("occupation", "ASTRONAUT");
        INPUT_DATA.put("residenceState", "AP");
        INPUT_DATA.put("validLicense", true);
    }
}

