/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.pmml;

import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.pmml.PMMLApplyModelBaseTest;

@RunWith(value=Parameterized.class)
public class ApplyScorecardModelIntegrationTest
extends PMMLApplyModelBaseTest {
    private static final String CORRELATION_ID = "123";
    private static final String MODEL_NAME = "CompoundPredicateScorecard";
    private static final String FILE_NAME = "CompoundPredicateScorecard.pmml";
    private static final String TARGET_FIELD = "score";
    private static final Object EXPECTED_RESULT = -93.0;
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 30000000L;
    private static final String MODEL_BASE = "scorecard";
    private static final String CONTAINER_ID_COMPILED = "scorecard-compiled";
    private static final String ARTIFACT_ID_COMPILED = "pmml-trusty-scorecard-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/pmml-trusty-scorecard-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "scorecard-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "pmml-trusty-scorecard-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/pmml-trusty-scorecard-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        ApplyScorecardModelIntegrationTest.setup(RESOURCE_COMPILED, 30000000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        ApplyScorecardModelIntegrationTest.setup(RESOURCE_NOT_COMPILED, 30000000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyPmmlScorecardModelCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyPmmlScorecardModelNotCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_NOT_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
        INPUT_DATA.put("input1", -21.5);
        INPUT_DATA.put("input2", -7.0);
        INPUT_DATA.put("input3", "classA");
        INPUT_DATA.put("input4", "classB");
    }
}

