/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.pmml;

import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.command.runtime.pmml.ApplyPmmlModelCommand;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.integrationtests.shared.KieServerAssert;
import org.kie.server.integrationtests.shared.KieServerDeployer;
import org.kie.server.integrationtests.shared.basetests.RestJmsSharedBaseIntegrationTest;

public abstract class PMMLApplyModelBaseTest
extends RestJmsSharedBaseIntegrationTest {
    protected static final String TEST_GROUP = "org.kie.server.testing.pmml-trusty";
    protected static final String TEST_VERSION = "1.0.0.Final";
    protected static final String PMML_TRUSTY_PREFIX = "pmml-trusty-";
    protected static final String COMPILED_SUFFIX = "-compiled";
    protected static final String NOT_COMPILED_SUFFIX = "-not-compiled";
    protected static final String KJAR_SOURCES_PREFIX = "/kjars-sources/";
    protected RuleServicesClient ruleClient;

    public static void setup(String resourceDir, long extendedTimeout, String containerId, ReleaseId releaseId) {
        commandsFactory = KieServices.Factory.get().getCommands();
        KieServerDeployer.buildAndDeployCommonMavenParent();
        KieServerDeployer.buildAndDeployMavenProjectFromResource((String)resourceDir);
        KieServicesClient client = PMMLApplyModelBaseTest.createDefaultStaticClient((long)extendedTimeout);
        ServiceResponse reply = client.createContainer(containerId, new KieContainerResource(containerId, releaseId));
        KieServerAssert.assertSuccess((ServiceResponse)reply);
    }

    protected void execute(String correlationId, String containerId, String modelName, String fileName, String targetField, Object expectedResult, Map<String, Object> inputData) {
        PMMLRequestData request = new PMMLRequestData(correlationId, modelName);
        request.setSource(fileName);
        inputData.forEach((arg_0, arg_1) -> ((PMMLRequestData)request).addRequestParam(arg_0, arg_1));
        ApplyPmmlModelCommand command = (ApplyPmmlModelCommand)commandsFactory.newApplyPmmlModel(request);
        ServiceResponse results = this.ruleClient.executeCommandsWithResults(containerId, (Command)command);
        Assertions.assertThat((Object)((ExecutionResults)results.getResult())).isNotNull();
        Assertions.assertThat((Object)((ExecutionResults)results.getResult()).getValue("results")).isNotNull();
        PMML4Result resultHolder = (PMML4Result)((ExecutionResults)results.getResult()).getValue("results");
        Assertions.assertThat((Object)resultHolder).isNotNull();
        Assertions.assertThat((String)resultHolder.getResultCode()).isEqualTo("OK");
        String resultObjectName = resultHolder.getResultObjectName();
        ((AbstractStringAssert)Assertions.assertThat((String)resultObjectName).isNotNull()).isEqualTo(targetField);
        Object obj = resultHolder.getResultValue(targetField, null, new Object[0]);
        ((ObjectAssert)Assertions.assertThat((Object)obj).isNotNull()).isEqualTo(expectedResult);
    }

    protected void setupClients(KieServicesClient kieServicesClient) {
        this.ruleClient = (RuleServicesClient)kieServicesClient.getServicesClient(RuleServicesClient.class);
    }
}

