/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.pmml;

import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.pmml.PMMLApplyModelBaseTest;

public class ApplyClusteringModelIntegrationTest
extends PMMLApplyModelBaseTest {
    private static final String CORRELATION_ID = "123";
    private static final String MODEL_NAME = "SingleIrisKMeansClustering";
    private static final String FILE_NAME = "SingleIrisKMeansClustering.pmml";
    private static final String TARGET_FIELD = "class";
    private static final Object EXPECTED_RESULT = "3";
    private static final Map<String, Object> INPUT_DATA;
    private static final long EXTENDED_TIMEOUT = 30000000L;
    private static final String MODEL_BASE = "clustering";
    private static final String CONTAINER_ID_COMPILED = "clustering-compiled";
    private static final String ARTIFACT_ID_COMPILED = "pmml-trusty-clustering-compiled";
    private static final ReleaseId RELEASE_ID_COMPILED;
    private static final String RESOURCE_COMPILED = "/kjars-sources/pmml-trusty-clustering-compiled";
    private static final String CONTAINER_ID_NOT_COMPILED = "clustering-not-compiled";
    private static final String ARTIFACT_ID_NOT_COMPILED = "pmml-trusty-clustering-not-compiled";
    private static final ReleaseId RELEASE_ID_NOT_COMPILED;
    private static final String RESOURCE_NOT_COMPILED = "/kjars-sources/pmml-trusty-clustering-not-compiled";

    @BeforeClass
    public static void buildAndDeployArtifacts() {
        ApplyClusteringModelIntegrationTest.setup(RESOURCE_COMPILED, 30000000L, CONTAINER_ID_COMPILED, RELEASE_ID_COMPILED);
        ApplyClusteringModelIntegrationTest.setup(RESOURCE_NOT_COMPILED, 30000000L, CONTAINER_ID_NOT_COMPILED, RELEASE_ID_NOT_COMPILED);
    }

    @Test
    public void testApplyPmmlRegressionModelCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    @Test
    public void testApplyPmmlRegressionModelNotCompiled() {
        this.execute(CORRELATION_ID, CONTAINER_ID_NOT_COMPILED, MODEL_NAME, FILE_NAME, TARGET_FIELD, EXPECTED_RESULT, INPUT_DATA);
    }

    static {
        RELEASE_ID_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_COMPILED, "1.0.0.Final");
        RELEASE_ID_NOT_COMPILED = new ReleaseId("org.kie.server.testing.pmml-trusty", ARTIFACT_ID_NOT_COMPILED, "1.0.0.Final");
        INPUT_DATA = new HashMap<String, Object>();
        INPUT_DATA.put("sepal_length", 4.4);
        INPUT_DATA.put("sepal_width", 3.0);
        INPUT_DATA.put("petal_length", 1.3);
        INPUT_DATA.put("petal_width", 0.2);
    }
}

