/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.jms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.server.api.ConversationId;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.jms.JMSConnection;
import org.kie.server.jms.JMSRuntimeException;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.kie.server.services.impl.security.adapters.JMSSecurityAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransactionManagement(value=TransactionManagementType.BEAN)
@MessageDriven(name="KieServerMDB", activationConfig={@ActivationConfigProperty(propertyName="destinationJndiName", propertyValue="queue/KIE.SERVER.REQUEST"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/KIE.SERVER.REQUEST"), @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge")})
public class KieServerMDB
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(KieServerMDB.class);
    private String RESPONSE_QUEUE_NAME = null;
    private static final String DEFAULT_RESPONSE_QUEUE_NAME = "queue/KIE.SERVER.RESPONSE";
    private static final String ID_NECESSARY = "This id is needed to be able to match a request to a response message.";
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory factory;
    private boolean sessionTransacted;
    private int sessionAck;
    private KieServerImpl kieServer;
    private Map<MarshallingFormat, Marshaller> marshallers;

    @PostConstruct
    public void init() {
        this.RESPONSE_QUEUE_NAME = System.getProperty("kie.server.jms.queues.response", DEFAULT_RESPONSE_QUEUE_NAME);
        this.sessionTransacted = Boolean.parseBoolean(System.getProperty("org.kie.server.jms.session.tx", "false"));
        this.sessionAck = Integer.parseInt(System.getProperty("org.kie.server.jms.session.ack", String.valueOf(1)));
        this.kieServer = KieServerLocator.getInstance();
        this.marshallers = new ConcurrentHashMap<MarshallingFormat, Marshaller>();
        ClassLoader classLoader = CommandScript.class.getClassLoader();
        this.marshallers.put(MarshallingFormat.XSTREAM, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)classLoader));
        this.marshallers.put(MarshallingFormat.JAXB, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)classLoader));
        this.marshallers.put(MarshallingFormat.JSON, MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)classLoader));
    }

    private JMSConnection startConnectionAndSession() {
        JMSConnection result = null;
        Connection connection = null;
        Session session = null;
        try {
            connection = this.factory.createConnection();
            if (connection != null) {
                session = connection.createSession(this.sessionTransacted, this.sessionAck);
                result = new JMSConnection(connection, session);
                if (logger.isDebugEnabled()) {
                    logger.debug("KieServerMDB sessionTransacted={}, sessionAck={}", (Object)this.sessionTransacted, (Object)this.sessionAck);
                }
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to obtain connection/session";
            logger.error(errMsg, (Throwable)jmse);
            throw new JMSRuntimeException(errMsg, jmse);
        }
        finally {
            if (connection != null && session == null) {
                logger.error("KieServerMDB: Session creation failed - closing connection");
                try {
                    connection.close();
                }
                catch (JMSException jmse) {
                    String errMsg = "KieServerMDB: Error closing connection after failing to open session";
                    throw new JMSRuntimeException(errMsg, jmse);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectionAndSession(JMSConnection connected) {
        Connection connection = null;
        Session session = null;
        if (connected == null) {
            logger.debug("KieServerMDB: JMSConnection is null, unable to close connection/session");
            return;
        }
        connection = connected.getConnection();
        session = connected.getSession();
        JMSException sessionError = null;
        if (session != null) {
            try {
                session.close();
                logger.debug("KieServerMDB: Session closed");
            }
            catch (JMSException jmse) {
                sessionError = jmse;
            }
            finally {
                session = null;
            }
        } else {
            logger.debug("KieServerMDB: session was 'null', so cannot be closed");
        }
        if (connection != null) {
            try {
                connection.close();
                connection = null;
                logger.debug("KieServerMDB: Connection closed");
            }
            catch (JMSException jmse) {
                String errMsg = sessionError != null ? "KieServerMDB: Error closing both session and connection" : "KieServerMDB: Error closing connection";
                logger.error(errMsg, (Throwable)jmse);
                throw new JMSRuntimeException(errMsg, jmse);
            }
            finally {
                if (connection == null && sessionError != null) {
                    logger.warn("KieServerMDB: Error closing session", (Throwable)sessionError);
                    logger.warn("KieServerMDB: Assuming session was closed by connection closure");
                    session = null;
                }
            }
        } else {
            logger.debug("KieServerMDB: connection was 'null', so cannot be closed");
            if (sessionError != null) {
                String errMsg = "KieServerMDB: Error closing session";
                logger.error(errMsg, (Throwable)sessionError);
                session = null;
                throw new JMSRuntimeException(errMsg, sessionError);
            }
        }
    }

    @PreDestroy
    public void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        block37: {
            JMSConnection connect = null;
            try {
                String username = null;
                String password = null;
                try {
                    username = message.getStringProperty("kie_user");
                    password = message.getStringProperty("kie_password");
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to retrieve user name and/or password, from message");
                }
                if (username != null && password != null) {
                    JMSSecurityAdapter.login((String)username, (String)password);
                } else {
                    logger.warn("Unable to login to JMSSecurityAdapter, user name and/or password missing");
                }
                KieContainerCommandService executor = null;
                String msgCorrId = null;
                try {
                    msgCorrId = message.getJMSCorrelationID();
                }
                catch (JMSException jmse) {
                    String errMsg = "Unable to retrieve JMS correlation id from message! This id is needed to be able to match a request to a response message.";
                    throw new JMSRuntimeException(errMsg, jmse);
                }
                String targetCapability = this.getStringProperty(message, "kie_target_capability", "KieServer");
                String containerId = this.getStringProperty(message, "container_id", null);
                String conversationId = this.getStringProperty(message, "kie_conversation_id", null);
                int interactionPattern = this.getIntProperty(message, "kie_interaction_pattern", 1);
                MarshallingFormat format = null;
                String classType = null;
                try {
                    classType = message.getStringProperty("kie_class_type");
                    if (!message.propertyExists("serialization_format")) {
                        format = MarshallingFormat.JAXB;
                    } else {
                        int intFormat = message.getIntProperty("serialization_format");
                        logger.debug("Serialization format (int) is {}", (Object)intFormat);
                        format = MarshallingFormat.fromId((int)intFormat);
                        logger.debug("Serialization format is {}", (Object)format);
                        if (format == null) {
                            String errMsg = "Unsupported marshalling format '" + intFormat + "' from message " + msgCorrId + ".";
                            throw new JMSRuntimeException(errMsg);
                        }
                    }
                }
                catch (JMSException jmse) {
                    String errMsg = "Unable to retrieve property 'serialization_format' from message " + msgCorrId + ".";
                    throw new JMSRuntimeException(errMsg, jmse);
                }
                Marshaller marshaller = this.getMarshaller(containerId, format);
                logger.debug("Selected marshaller is {}", (Object)marshaller);
                CommandScript script = KieServerMDB.unmarshallRequest(message, msgCorrId, marshaller, format);
                logger.debug("Target capability is {}", (Object)targetCapability);
                for (KieServerExtension extension : this.kieServer.getServerExtensions()) {
                    KieContainerCommandService tmp = (KieContainerCommandService)extension.getAppComponents(KieContainerCommandService.class);
                    if (tmp == null || !extension.getImplementedCapability().equalsIgnoreCase(targetCapability)) continue;
                    executor = tmp;
                    logger.debug("Extension {} returned command executor {} with capability {}", new Object[]{extension, executor, extension.getImplementedCapability()});
                    break;
                }
                if (executor == null) {
                    throw new IllegalStateException("No executor found for script execution");
                }
                ServiceResponsesList response = executor.executeScript(script, format, classType);
                if (interactionPattern < 100) {
                    connect = this.startConnectionAndSession();
                    logger.debug("Response message is about to be sent according to selected interaction pattern {}", (Object)interactionPattern);
                    Message msg = KieServerMDB.marshallResponse(connect.getSession(), msgCorrId, format, marshaller, response);
                    if (containerId != null && (conversationId == null || conversationId.trim().isEmpty())) {
                        try {
                            KieContainerInstanceImpl containerInstance = this.kieServer.getServerRegistry().getContainer(containerId);
                            if (containerInstance != null) {
                                ReleaseId releaseId = containerInstance.getResource().getResolvedReleaseId();
                                if (releaseId == null) {
                                    releaseId = containerInstance.getResource().getReleaseId();
                                }
                                conversationId = ConversationId.from((String)KieServerEnvironment.getServerId(), (String)containerId, (ReleaseId)releaseId).toString();
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Unable to build conversation id due to {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                    try {
                        if (conversationId != null) {
                            msg.setStringProperty("kie_conversation_id", conversationId);
                        }
                    }
                    catch (JMSException e) {
                        logger.debug("Unable to set conversation id on response message due to {}", (Object)e.getMessage());
                    }
                    this.sendResponse(connect.getSession(), msgCorrId, format, msg);
                } else {
                    logger.debug("Response message is skipped according to selected interaction pattern {}", (Object)101);
                }
                if (connect == null) break block37;
            }
            catch (Throwable throwable) {
                if (connect != null) {
                    try {
                        this.closeConnectionAndSession(connect);
                    }
                    catch (JMSRuntimeException runtimeException) {
                        logger.error("Error while attempting to close connection/session", (Throwable)runtimeException);
                    }
                    finally {
                        JMSSecurityAdapter.logout();
                    }
                } else {
                    JMSSecurityAdapter.logout();
                }
                throw throwable;
            }
            try {
                this.closeConnectionAndSession(connect);
            }
            catch (JMSRuntimeException runtimeException) {
                logger.error("Error while attempting to close connection/session", (Throwable)runtimeException);
            }
            finally {
                JMSSecurityAdapter.logout();
            }
        }
        JMSSecurityAdapter.logout();
    }

    private static CommandScript unmarshallRequest(Message message, String msgId, Marshaller serializationProvider, MarshallingFormat format) {
        CommandScript cmdMsg = null;
        try {
            String msgStrContent = ((TextMessage)message).getText();
            logger.debug("About to unmarshal content '{}'", (Object)msgStrContent);
            cmdMsg = (CommandScript)serializationProvider.unmarshall(msgStrContent, CommandScript.class);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to read information from message " + msgId + ".";
            throw new JMSRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to unmarshall request to " + CommandScript.class.getSimpleName() + " [msg id: " + msgId + "].";
            throw new JMSRuntimeException(errMsg, e);
        }
        return cmdMsg;
    }

    private static Message marshallResponse(Session session, String msgId, MarshallingFormat format, Marshaller marshaller, ServiceResponsesList response) {
        TextMessage textMsg = null;
        try {
            String msgStr = marshaller.marshall((Object)response);
            textMsg = session.createTextMessage(msgStr);
            textMsg.setIntProperty("serialization_format", format.getId());
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to create response message or write to it [msg id: " + msgId + "].";
            throw new JMSRuntimeException(errMsg, jmse);
        }
        catch (Exception e) {
            String errMsg = "Unable to serialize " + response.getClass().getSimpleName() + " to a String.";
            throw new JMSRuntimeException(errMsg, e);
        }
        return textMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(Session session, String msgCorrId, MarshallingFormat format, Message msg) {
        try {
            msg.setJMSCorrelationID(msgCorrId);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to set correlation id of response to msg id " + msgCorrId;
            logger.error(errMsg, (Throwable)jmse);
            return;
        }
        MessageProducer producer = null;
        try {
            Queue responseQueue = (Queue)new InitialContext().lookup(this.RESPONSE_QUEUE_NAME);
            producer = session.createProducer((Destination)responseQueue);
            producer.send(msg);
        }
        catch (NamingException ne) {
            String errMsg = "Unable to lookup response queue " + this.RESPONSE_QUEUE_NAME + " to send msg " + msgCorrId + " (Is " + "kie.server.jms.queues.response" + " incorrect?).";
            logger.error(errMsg, (Throwable)ne);
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to send msg " + msgCorrId + " to " + this.RESPONSE_QUEUE_NAME;
            logger.error(errMsg, (Throwable)jmse);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    logger.debug("Closing the producer resulted in an exception: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected Marshaller getMarshaller(String containerId, MarshallingFormat format) {
        if (containerId == null || containerId.isEmpty()) {
            return this.marshallers.get(format);
        }
        KieContainerInstanceImpl kieContainerInstance = this.kieServer.getServerRegistry().getContainer(containerId);
        if (kieContainerInstance != null && kieContainerInstance.getKieContainer() != null) {
            return kieContainerInstance.getMarshaller(format);
        }
        return this.marshallers.get(format);
    }

    protected String getStringProperty(Message message, String name, String defaultValue) {
        try {
            if (message.propertyExists(name)) {
                return message.getStringProperty(name);
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve property '" + name + "' from message " + message + ".";
            logger.debug(errMsg, (Throwable)jmse);
        }
        return defaultValue;
    }

    protected int getIntProperty(Message message, String name, int defaultValue) {
        try {
            if (message.propertyExists(name)) {
                return message.getIntProperty(name);
            }
        }
        catch (JMSException jmse) {
            String errMsg = "Unable to retrieve property '" + name + "' from message " + message + ".";
            logger.debug(errMsg, (Throwable)jmse);
        }
        return defaultValue;
    }
}

