/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.casemgmt;

import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.cases.CaseDefinitionList;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.remote.rest.casemgmt.CaseQueryResource;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseQueryResourceTest {
    @Mock
    HttpHeaders httpHeaders;
    @Mock
    CaseManagementRuntimeDataServiceBase runtimeDataService;
    @Spy
    KieServerRegistry kieServerRegistry = new KieServerRegistryImpl();
    CaseQueryResource caseQueryResource;

    @Before
    public void init() {
        Mockito.when((Object)this.httpHeaders.getRequestHeaders()).thenReturn((Object)new MultivaluedHashMap());
        this.caseQueryResource = new CaseQueryResource(this.runtimeDataService, this.kieServerRegistry);
    }

    @Test
    public void testGetCaseDefinitions() {
        String filter = null;
        Integer page = 0;
        Integer pageSize = 10;
        String sort = "CaseId";
        boolean sortOrder = true;
        Mockito.when((Object)this.runtimeDataService.getCaseDefinitions(filter, page, pageSize, sort, sortOrder)).thenReturn((Object)new CaseDefinitionList());
        this.caseQueryResource.getCaseDefinitions(this.httpHeaders, filter, page, pageSize, sort, sortOrder);
        ((KieServerRegistry)Mockito.verify((Object)this.kieServerRegistry)).getContainer("");
        ((CaseManagementRuntimeDataServiceBase)Mockito.verify((Object)this.runtimeDataService)).getCaseDefinitions(filter, page, pageSize, sort, sortOrder);
    }

    @Test
    public void testGetCaseInstances() {
        List status = null;
        Integer page = 0;
        Integer pageSize = 10;
        String sort = "CorrelationKey";
        boolean sortOrder = true;
        Mockito.when((Object)this.runtimeDataService.getCaseInstances(status, page, pageSize, sort, sortOrder)).thenReturn((Object)new CaseInstanceList());
        this.caseQueryResource.getCaseInstances(this.httpHeaders, null, null, null, status, page, pageSize, sort, sortOrder);
        ((KieServerRegistry)Mockito.verify((Object)this.kieServerRegistry)).getContainer("");
        ((CaseManagementRuntimeDataServiceBase)Mockito.verify((Object)this.runtimeDataService)).getCaseInstancesAnyRole(status, page, pageSize, sort, sortOrder);
    }
}

