/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.resource;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.impl.marshal.MarshallerHelper;

@Path(value="/server")
public class KieServerResource {
    private KieContainerCommandService delegate;
    private MarshallerHelper marshallerHelper = new MarshallerHelper(null);

    public KieServerResource(KieContainerCommandService delegate) {
        this.delegate = delegate;
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response executeCommands(@Context HttpHeaders headers, String commandScriptPayload) {
        String contentType = RestUtils.getContentType(headers);
        CommandScript command = (CommandScript)this.marshallerHelper.unmarshal(commandScriptPayload, contentType, CommandScript.class);
        ServiceResponsesList result = this.delegate.executeScript(command, MarshallerHelper.getFormat((String)contentType), null);
        return RestUtils.createCorrectVariant(result, headers);
    }
}

