/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.exception;

import javax.ws.rs.core.Variant;

public class ExecutionServerRestOperationException
extends RuntimeException {
    private static final long serialVersionUID = 3065096836333886139L;
    protected Integer status = null;
    private final Variant variant;

    public ExecutionServerRestOperationException(String s, Variant v) {
        super(s);
        this.variant = v;
    }

    protected ExecutionServerRestOperationException(String s, Status status, Variant v) {
        this(s, v);
        this.status = status.getValue();
    }

    public ExecutionServerRestOperationException(String s, Throwable throwable, Variant v) {
        super(s, throwable);
        this.variant = v;
    }

    protected ExecutionServerRestOperationException(String s, Throwable throwable, Status status, Variant v) {
        this(s, throwable, v);
        this.status = status.getValue();
    }

    public int getStatus() {
        return this.status;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public static ExecutionServerRestOperationException badRequest(String msg, Variant v) {
        return new ExecutionServerRestOperationException(msg, Status.BAD_REQUEST, v);
    }

    public static ExecutionServerRestOperationException forbidden(String msg, Variant v) {
        return new ExecutionServerRestOperationException(msg, Status.FORBIDDEN, v);
    }

    public static ExecutionServerRestOperationException conflict(String msg, Exception e, Variant v) {
        return new ExecutionServerRestOperationException(msg, (Throwable)e, Status.CONFLICT, v);
    }

    public static ExecutionServerRestOperationException notFound(String msg, Variant v) {
        return new ExecutionServerRestOperationException(msg, Status.NOT_FOUND, v);
    }

    public static ExecutionServerRestOperationException notFound(String msg, Exception e, Variant v) {
        return new ExecutionServerRestOperationException(msg, (Throwable)e, Status.NOT_FOUND, v);
    }

    public static ExecutionServerRestOperationException internalServerError(String msg, Variant v) {
        return new ExecutionServerRestOperationException(msg, Status.INTERNAL_SERVER_ERROR, v);
    }

    public static ExecutionServerRestOperationException internalServerError(String msg, Exception e, Variant v) {
        return new ExecutionServerRestOperationException(msg, (Throwable)e, Status.INTERNAL_SERVER_ERROR, v);
    }

    public static enum Status {
        BAD_REQUEST(400),
        FORBIDDEN(403),
        NOT_FOUND(404),
        CONFLICT(409),
        INTERNAL_SERVER_ERROR(500),
        METHOD_NOT_ALLOWED(405),
        GONE(410),
        PRE_CONDITION_FAILED(412),
        NOT_ACCEPTABLE(406),
        UNSUPPORTED_MEDIA_TYPE(415),
        UNAUTHORIZED(401);

        private final int status;

        private Status(int s) {
            this.status = s;
        }

        public int getValue() {
            return this.status;
        }
    }
}

