/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.util;

import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.server.services.impl.marshal.MarshallerHelper;

public class RestUtils {
    public static Variant defaultVariant = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build().get(0);
    private static MarshallerHelper marshallerHelper = new MarshallerHelper(null);

    public static Response createCorrectVariant(Object responseObj, HttpHeaders headers) {
        return RestUtils.createCorrectVariant(responseObj, headers, null);
    }

    public static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestUtils.getVariant(headers);
        String contentType = RestUtils.getContentType(headers);
        responseBuilder = status != null ? Response.status((Response.Status)status).entity((Object)marshallerHelper.marshal(contentType, responseObj)).variant(v) : Response.ok((Object)marshallerHelper.marshal(contentType, responseObj), (Variant)v);
        return responseBuilder.build();
    }

    public static Response createResponse(Object responseObj, Variant v, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }

    public static Variant getVariant(HttpHeaders headers) {
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = defaultVariant;
        }
        return v;
    }

    public static String getClassType(HttpHeaders headers) {
        String classType = null;
        List header = headers.getRequestHeader("X-KIE-ClassType");
        if (header != null && !header.isEmpty()) {
            classType = (String)header.get(0);
        }
        return classType;
    }

    public static String getContentType(HttpHeaders headers) {
        Variant v = RestUtils.getVariant(headers);
        String contentType = v.getMediaType().getSubtype();
        List kieContentTypeHeader = headers.getRequestHeader("X-KIE-ContentType");
        if (kieContentTypeHeader != null && !kieContentTypeHeader.isEmpty()) {
            contentType = (String)kieContentTypeHeader.get(0);
        }
        return contentType;
    }
}

