/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.util;

import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.ConversationId;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.common.rest.RestEasy960Util;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.marshal.MarshallerHelper;

public class RestUtils {
    private static MarshallerHelper marshallerHelper = new MarshallerHelper(null);
    private static Variant ERROR_VARIANT = new Variant(MediaType.TEXT_PLAIN_TYPE, (Locale)null, null);

    public static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Header ... customHeaders) {
        return RestUtils.createCorrectVariant(responseObj, headers, null, customHeaders);
    }

    public static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status, Header ... customHeaders) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestUtils.getVariant(headers);
        String contentType = RestUtils.getContentType(headers);
        responseBuilder = status != null ? Response.status((Response.Status)status).entity((Object)marshallerHelper.marshal(contentType, responseObj)).variant(v) : Response.ok((Object)marshallerHelper.marshal(contentType, responseObj), (Variant)v);
        RestUtils.applyCustomHeaders(responseBuilder, customHeaders);
        return responseBuilder.build();
    }

    public static Response createCorrectVariant(MarshallerHelper marshallerHelper, String containerId, Object responseObj, HttpHeaders headers, Response.Status status, Header ... customHeaders) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestUtils.getVariant(headers);
        String contentType = RestUtils.getContentType(headers);
        String marshalledResponse = marshallerHelper.getRegistry().getContainer(containerId) == null ? marshallerHelper.marshal(contentType, responseObj) : marshallerHelper.marshal(containerId, contentType, responseObj);
        responseBuilder = status != null ? Response.status((Response.Status)status).entity((Object)marshalledResponse).variant(v) : Response.ok((Object)marshalledResponse, (Variant)v);
        RestUtils.applyCustomHeaders(responseBuilder, customHeaders);
        return responseBuilder.build();
    }

    public static Response createResponse(Object responseObj, Variant v, Response.Status status, Header ... customHeaders) {
        Response.ResponseBuilder responseBuilder = null;
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        RestUtils.applyCustomHeaders(responseBuilder, customHeaders);
        return responseBuilder.build();
    }

    public static Variant getVariant(HttpHeaders headers) {
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{RestUtils.getMediaType(headers)}).add().build().get(0);
        }
        return v;
    }

    public static String getClassType(HttpHeaders headers) {
        String classType = null;
        List header = headers.getRequestHeader("X-KIE-ClassType");
        if (header != null && !header.isEmpty()) {
            classType = (String)header.get(0);
        }
        return classType;
    }

    public static String getContentType(HttpHeaders headers) {
        List kieContentTypeHeader;
        List contentTypeHeader;
        String contentType = MediaType.APPLICATION_XML_TYPE.toString();
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v != null) {
            contentType = v.getMediaType().toString();
        }
        if ((contentTypeHeader = headers.getRequestHeader("Content-Type")) != null && !contentTypeHeader.isEmpty() && contentTypeHeader.get(0) != null) {
            contentType = (String)contentTypeHeader.get(0);
        }
        if ((kieContentTypeHeader = headers.getRequestHeader("X-KIE-ContentType")) != null && !kieContentTypeHeader.isEmpty()) {
            contentType = (String)kieContentTypeHeader.get(0);
        }
        return contentType;
    }

    public static MediaType getMediaType(HttpHeaders httpHeaders) {
        String contentType = RestUtils.getContentType(httpHeaders);
        try {
            return MediaType.valueOf((String)contentType);
        }
        catch (IllegalArgumentException e) {
            MarshallingFormat format = MarshallingFormat.fromType((String)contentType);
            switch (format) {
                case JAXB: {
                    return MediaType.APPLICATION_XML_TYPE;
                }
                case XSTREAM: {
                    return MediaType.APPLICATION_XML_TYPE;
                }
                case JSON: {
                    return MediaType.APPLICATION_JSON_TYPE;
                }
            }
            return MediaType.APPLICATION_XML_TYPE;
        }
    }

    public static Response permissionDenied(String message, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse(message, v, Response.Status.UNAUTHORIZED, customHeaders);
    }

    public static Response notFound(String message, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse("\"" + message + "\"", ERROR_VARIANT, Response.Status.NOT_FOUND, customHeaders);
    }

    public static Response internalServerError(String message, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse("\"" + message + "\"", ERROR_VARIANT, Response.Status.INTERNAL_SERVER_ERROR, customHeaders);
    }

    public static Response alreadyExists(String message, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse("\"" + message + "\"", ERROR_VARIANT, Response.Status.CONFLICT, customHeaders);
    }

    public static Response badRequest(String reason, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse("\"" + reason + "\"", ERROR_VARIANT, Response.Status.BAD_REQUEST, customHeaders);
    }

    public static Response forbidden(String reason, Variant v, Header ... customHeaders) {
        return RestUtils.createResponse("\"" + reason + "\"", ERROR_VARIANT, Response.Status.FORBIDDEN, customHeaders);
    }

    public static Response noContent(Variant v, Header ... customHeaders) {
        return RestUtils.createResponse("", v, Response.Status.NO_CONTENT, customHeaders);
    }

    public static Response serviceUnavailable(Header ... customHeaders) {
        return RestUtils.createResponse("", ERROR_VARIANT, Response.Status.SERVICE_UNAVAILABLE, customHeaders);
    }

    protected static void applyCustomHeaders(Response.ResponseBuilder builder, Header ... customHeaders) {
        if (customHeaders != null && customHeaders.length > 0) {
            for (Header header : customHeaders) {
                if (header == null) continue;
                builder.header(header.getName(), (Object)header.getValue());
            }
        }
    }

    public static Header buildConversationIdHeader(String containerId, KieServerRegistry registry, HttpHeaders headers) {
        List conversationIdHeader = headers.getRequestHeader("X-KIE-ConversationId");
        if (conversationIdHeader != null && !conversationIdHeader.isEmpty()) {
            return new Header("X-KIE-ConversationId", (String)conversationIdHeader.get(0));
        }
        KieContainerInstanceImpl container = registry.getContainer(containerId);
        if (container != null && KieContainerStatus.STARTED.equals((Object)container.getStatus())) {
            ReleaseId releaseId = container.getResource().getResolvedReleaseId();
            if (releaseId == null) {
                releaseId = container.getResource().getReleaseId();
            }
            String conversationId = ConversationId.from((String)KieServerEnvironment.getServerId(), (String)containerId, (ReleaseId)releaseId).toString();
            return new Header("X-KIE-ConversationId", conversationId);
        }
        return null;
    }
}

