/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.impl.marshal.MarshallerHelper;

@Api(value="KIE Server Script :: Core")
@Path(value="server/config")
public class KieServerResource {
    private KieContainerCommandService delegate;
    private MarshallerHelper marshallerHelper = new MarshallerHelper(null);

    public KieServerResource() {
    }

    public KieServerResource(KieContainerCommandService delegate) {
        this.delegate = delegate;
    }

    @ApiOperation(value="Executes command script on execution server, usually used as a batch to configure KIE Server", response=ServiceResponsesList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response executeCommands(@Context HttpHeaders headers, @ApiParam(value="command script payload", required=true) String commandScriptPayload) {
        String contentType = RestUtils.getContentType(headers);
        CommandScript command = (CommandScript)this.marshallerHelper.unmarshal(commandScriptPayload, contentType, CommandScript.class);
        ServiceResponsesList result = this.delegate.executeScript(command, MarshallerHelper.getFormat((String)contentType), null);
        return RestUtils.createCorrectVariant((Object)result, headers, new Header[0]);
    }
}

