/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common.resource;

import java.io.File;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerRestImplTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");
    private static final String KIE_SERVER_ID = "kie-server-impl-test";
    private KieServerImpl kieServer;
    private String origServerId = null;
    private Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
    @Mock
    private HttpHeaders headers;

    @Before
    public void setupKieServerImpl() throws Exception {
        System.setProperty("org.kie.server.mgmt.api.disabled", "true");
        this.origServerId = KieServerEnvironment.getServerId();
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        KieServerEnvironment.setServerId((String)KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR));
        MultivaluedHashMap mockedRequestHeaders = new MultivaluedHashMap();
        mockedRequestHeaders.add((Object)"Accept", (Object)"application/json");
        Mockito.when((Object)this.headers.getRequestHeaders()).thenReturn((Object)mockedRequestHeaders);
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
        KieServerEnvironment.setServerId((String)this.origServerId);
        System.clearProperty("org.kie.server.mgmt.api.disabled");
    }

    @Test
    public void testCreateContainerWithManagementDisabled() {
        KieServerRestImpl restServer = new KieServerRestImpl(this.kieServer);
        Response response = restServer.createContainer(this.headers, "test", "");
        this.assertForbiddenResponse(response);
    }

    @Test
    public void testDisposeContainerWithManagementDisabled() {
        KieServerRestImpl restServer = new KieServerRestImpl(this.kieServer);
        Response response = restServer.disposeContainer(this.headers, "test");
        this.assertForbiddenResponse(response);
    }

    @Test
    public void testUpdateReleaseIdWithManagementDisabled() {
        KieServerRestImpl restServer = new KieServerRestImpl(this.kieServer);
        Response response = restServer.updateReleaseId(this.headers, "test", "");
        this.assertForbiddenResponse(response);
    }

    @Test
    public void testUpdateScannerWithManagementDisabled() {
        KieServerRestImpl restServer = new KieServerRestImpl(this.kieServer);
        Response response = restServer.updateScanner(this.headers, "test", "");
        this.assertForbiddenResponse(response);
    }

    private void assertForbiddenResponse(Response response) {
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        ServiceResponse serviceResponse = (ServiceResponse)this.marshaller.unmarshall((String)response.getEntity(), ServiceResponse.class);
        Assert.assertNotNull((Object)serviceResponse);
        Assert.assertEquals((Object)KieServiceResponse.ResponseType.FAILURE, (Object)serviceResponse.getType());
        Assert.assertEquals((Object)"KIE Server management api is disabled", (Object)serviceResponse.getMsg());
    }
}

