/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.common;

import java.nio.charset.Charset;
import java.util.UUID;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class Bootstrap
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(Bootstrap.class);

    public void contextInitialized(ServletContextEvent sce) {
        KieServerEnvironment.setContextRoot((String)sce.getServletContext().getContextPath());
        if (KieServerEnvironment.getServerId() == null) {
            String serverName = sce.getServletContext().getServletContextName() + "@" + sce.getServletContext().getContextPath();
            String serverId = UUID.nameUUIDFromBytes(serverName.getBytes(Charset.forName("UTF-8"))).toString();
            KieServerEnvironment.setServerId((String)serverId.toString());
            KieServerEnvironment.setServerName((String)serverName);
        }
        logger.info("KieServer (id {} (name {})) started initialization process", (Object)KieServerEnvironment.getServerId(), (Object)KieServerEnvironment.getServerName());
        KieServerLocator.getInstance();
        logger.info("KieServer (id {}) started successfully", (Object)KieServerEnvironment.getServerId());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        KieServerImpl server = KieServerLocator.getInstance();
        server.destroy();
        logger.info("KieServer (id {}) destroyed successfully", (Object)KieServerEnvironment.getServerId());
    }
}

