/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.ui;

import java.text.MessageFormat;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.jbpm.ui.FormServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/containers/{id}/forms")
public class FormResource {
    private static final Logger logger = LoggerFactory.getLogger(FormResource.class);
    private static int PRETTY_PRINT_INDENT_FACTOR = 4;
    private FormServiceBase formServiceBase;

    public FormResource() {
    }

    public FormResource(FormServiceBase formServiceBase) {
        this.formServiceBase = formServiceBase;
    }

    @GET
    @Path(value="processes/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessForm(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @QueryParam(value="lang") @DefaultValue(value="en") String language) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String response = this.formServiceBase.getFormDisplayProcess(containerId, processId, language);
            if (response != null && !response.isEmpty() && v.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                JSONObject json = XML.toJSONObject((String)response);
                this.formatJSONResponse(json);
                response = json.toString(PRETTY_PRINT_INDENT_FACTOR);
            }
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)("Form for process id " + processId + " not found"), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="tasks/{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskForm(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="lang") @DefaultValue(value="en") String language) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String response = this.formServiceBase.getFormDisplayTask(taskId.longValue(), language);
            if (v.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                JSONObject json = XML.toJSONObject((String)response);
                this.formatJSONResponse(json);
                response = json.toString(PRETTY_PRINT_INDENT_FACTOR);
            }
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)("Form for task id " + taskId + " not found"), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)v);
        }
    }

    private void formatJSONResponse(JSONObject json) {
        try {
            JSONObject form = json.getJSONObject("form");
            this.putPropertyArrayToObject(form);
            Object fields = form.get("field");
            if (fields instanceof JSONArray) {
                for (int i = 0; i < ((JSONArray)fields).length(); ++i) {
                    JSONObject field = ((JSONArray)fields).getJSONObject(i);
                    this.putPropertyArrayToObject(field);
                }
            } else {
                this.putPropertyArrayToObject((JSONObject)fields);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void putPropertyArrayToObject(JSONObject obj) throws JSONException {
        JSONArray properties = obj.getJSONArray("property");
        for (int j = 0; j < properties.length(); ++j) {
            JSONObject property = properties.getJSONObject(j);
            obj.put(property.getString("name"), property.get("value"));
        }
        obj.remove("property");
    }
}

