/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.ui;

import java.text.MessageFormat;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.jbpm.ui.ImageServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/containers/{id}/images")
public class ImageResource {
    private static final Logger logger = LoggerFactory.getLogger(ImageResource.class);
    private ImageServiceBase imageServiceBase;

    public ImageResource() {
    }

    public ImageResource(ImageServiceBase imageServiceBase) {
        this.imageServiceBase = imageServiceBase;
    }

    @GET
    @Path(value="processes/{pId}")
    @Produces(value={"application/svg+xml"})
    public Response getProcessImage(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String svgString = this.imageServiceBase.getProcessImage(containerId, processId);
            logger.debug("Returning OK response with content '{}'", (Object)svgString);
            return RestUtils.createResponse((Object)svgString, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)("Image for process id " + processId + " not found"), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="processes/instances/{pInstanceId}")
    @Produces(value={"application/svg+xml"})
    public Response getProcessInstanceImage(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long procInstId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            String svgString = this.imageServiceBase.getActiveProcessImage(containerId, procInstId.longValue());
            logger.debug("Returning OK response with content '{}'", (Object)svgString);
            return RestUtils.createResponse((Object)svgString, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Not found", e.getMessage()), (Variant)v);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)("Image for process instance id " + procInstId + " not found"), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)v);
        }
    }
}

