/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.ui;

import java.text.MessageFormat;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.ui.FormServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/containers/{id}/forms")
public class FormResource {
    private static final Logger logger = LoggerFactory.getLogger(FormResource.class);
    private static int PRETTY_PRINT_INDENT_FACTOR = 4;
    public static final String CONTAINER_NOT_FOUND = "Could not find container \"{0}\"";
    public static final String PROCESS_DEFINITION_NOT_FOUND = "Could not find process definition \"{0}\" in container \"{1}\"";
    private FormServiceBase formServiceBase;
    private KieServerRegistry context;

    public FormResource() {
    }

    public FormResource(FormServiceBase formServiceBase, KieServerRegistry context) {
        this.formServiceBase = formServiceBase;
        this.context = context;
    }

    @GET
    @Path(value="processes/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessForm(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @QueryParam(value="lang") @DefaultValue(value="en") String language, @QueryParam(value="filter") boolean filter, @QueryParam(value="type") @DefaultValue(value="ANY") String formType, @QueryParam(value="marshallContent") @DefaultValue(value="true") boolean marshallContent) {
        Variant variant = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.formServiceBase.getFormDisplayProcess(containerId, processId, language, filter, formType);
            if (marshallContent) {
                response = this.marshallFormContent(response, formType, variant);
            }
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)variant, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(CONTAINER_NOT_FOUND, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(PROCESS_DEFINITION_NOT_FOUND, processId, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)("Form for process id " + processId + " not found"), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskForm(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="lang") @DefaultValue(value="en") String language, @QueryParam(value="filter") boolean filter, @QueryParam(value="type") @DefaultValue(value="ANY") String formType, @QueryParam(value="marshallContent") @DefaultValue(value="true") boolean marshallContent) {
        Variant variant = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.formServiceBase.getFormDisplayTask(taskId.longValue(), language, filter, formType);
            if (marshallContent) {
                response = this.marshallFormContent(response, formType, variant);
            }
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)variant, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(CONTAINER_NOT_FOUND, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)("Form for task id " + taskId + " not found"), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected String marshallFormContent(String formContent, String formType, Variant variant) throws Exception {
        if (StringUtils.isEmpty((CharSequence)formContent)) {
            return formContent;
        }
        FormServiceBase.FormType actualFormType = FormServiceBase.FormType.fromName((String)formType);
        String actualContentType = actualFormType.getContentType();
        if (actualContentType == null) {
            actualContentType = this.getMediaTypeForFormContent(formContent);
        }
        if (variant.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) && !MediaType.APPLICATION_JSON_TYPE.getSubtype().equals(actualContentType)) {
            JSONObject json = XML.toJSONObject((String)formContent);
            this.formatJSONResponse(json);
            formContent = json.toString(PRETTY_PRINT_INDENT_FACTOR);
        } else if (variant.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE) && !MediaType.APPLICATION_XML_TYPE.getSubtype().equals(actualContentType)) {
            Object json = this.parseToJSON(formContent);
            formContent = XML.toString((Object)json);
        }
        return formContent;
    }

    protected String getMediaTypeForFormContent(String contentType) {
        if (contentType != null) {
            if (contentType.startsWith("{") || contentType.startsWith("[")) {
                return MediaType.APPLICATION_JSON_TYPE.getSubtype();
            }
            if (contentType.startsWith("<")) {
                return MediaType.APPLICATION_XML_TYPE.getSubtype();
            }
        }
        return null;
    }

    private void formatJSONResponse(JSONObject json) {
        try {
            JSONObject form = json.getJSONObject("form");
            this.putPropertyArrayToObject(form);
            Object fields = form.get("field");
            if (fields instanceof JSONArray) {
                for (int i = 0; i < ((JSONArray)fields).length(); ++i) {
                    JSONObject field = ((JSONArray)fields).getJSONObject(i);
                    this.putPropertyArrayToObject(field);
                }
            } else {
                this.putPropertyArrayToObject((JSONObject)fields);
            }
        }
        catch (JSONException e) {
            logger.debug("exception while formatting :: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void putPropertyArrayToObject(JSONObject obj) throws JSONException {
        JSONArray properties = obj.getJSONArray("property");
        for (int j = 0; j < properties.length(); ++j) {
            JSONObject property = properties.getJSONObject(j);
            obj.put(property.getString("name"), property.get("value"));
        }
        obj.remove("property");
    }

    private Object parseToJSON(String content) throws JSONException {
        try {
            return new JSONArray(content);
        }
        catch (JSONException e) {
            return new JSONObject(content);
        }
    }
}

