/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Queries - processes, nodes, variables and tasks :: BPM")
@Path(value="server/queries")
public class RuntimeDataResource {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeDataResource.class);
    private RuntimeDataServiceBase runtimeDataServiceBase;
    private KieServerRegistry context;

    public RuntimeDataResource() {
    }

    public RuntimeDataResource(RuntimeDataServiceBase delegate, KieServerRegistry context) {
        this.runtimeDataServiceBase = delegate;
        this.context = context;
    }

    @ApiOperation(value="Retrieves process instances filtered by status, initiator, processName - depending what query parameters are given. Applies pagination by default and allows to specify sorting", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstances(@Context HttpHeaders headers, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional process instance initiator - user who started process instance to filter process instances", required=false) @QueryParam(value="initiator") String initiator, @ApiParam(value="optional process name to filter process instances", required=false) @QueryParam(value="processName") String processName, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstances(status, initiator, processName, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process instances filtered by process id. Applies pagination by default and allows to specify sorting", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/{pId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByProcessId(@Context HttpHeaders headers, @ApiParam(value="process id to filter process instance", required=true) @PathParam(value="pId") String processId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optinal process instance initiator - user who started process instance to filtr process instances", required=false) @QueryParam(value="initiator") String initiator, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByProcessId(processId, status, initiator, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process instances filtered by container. Applies pagination by default and allows to specify sorting", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found")})
    @GET
    @Path(value="containers/{id}/process/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByDeploymentId(@Context HttpHeaders headers, @ApiParam(value="container id to filter process instance", required=true) @PathParam(value="id") String containerId, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByDeploymentId(containerId, status, page, pageSize, sort, sortOrder);
            logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
            return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves process instance by exactly matched correlation key", response=ProcessInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/instance/correlation/{correlationKey}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceByCorrelationKey(@Context HttpHeaders headers, @ApiParam(value="correlation key associated with process instance", required=true) @PathParam(value="correlationKey") String correlationKey) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstance processInstance = this.runtimeDataServiceBase.getProcessInstanceByCorrelationKey(correlationKey);
        if (processInstance == null) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", correlationKey), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process instances filtered by correlation key, retrieves all process instances that match correlationkey*. Applies pagination by default and allows to specify sorting", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/instances/correlation/{correlationKey}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByCorrelationKey(@Context HttpHeaders headers, @ApiParam(value="correlation key to filter process instance, can be given as partial correlation key like in starts with approach", required=true) @PathParam(value="correlationKey") String correlationKey, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByCorrelationKey(correlationKey, page, pageSize, sort, sortOrder);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process instances filtered by by variable or by variable and its value. Applies pagination by default and allows to specify sorting", response=ProcessInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/instances/variables/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceByVariables(@Context HttpHeaders headers, @ApiParam(value="variable name to filter process instance", required=true) @PathParam(value="varName") String variableName, @ApiParam(value="variable value to filter process instance, optional when filtering by name only required when filtering by name and value", required=false) @QueryParam(value="varValue") String variableValue, @ApiParam(value="optional process instance status (active, completed, aborted) - defaults ot active (1) only", required=false, allowableValues="1,2,3") @QueryParam(value="status") List<Integer> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstanceByVariables(variableName, variableValue, status, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process instance for given process instance id and optionally loads its variables", response=ProcessInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance id not found")})
    @GET
    @Path(value="processes/instances/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceById(@Context HttpHeaders headers, @ApiParam(value="process instance id to retrieve process instance", required=true) @PathParam(value="pInstanceId") long processInstanceId, @ApiParam(value="load process instance variables or not, defaults to false", required=false) @QueryParam(value="withVars") boolean withVars) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstance processInstanceDesc = null;
        try {
            processInstanceDesc = this.runtimeDataServiceBase.getProcessInstanceById(processInstanceId, withVars);
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processInstanceDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves node instance for given process instance id and work item id", response=NodeInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Node instance id not found")})
    @GET
    @Path(value="processes/instances/{pInstanceId}/wi-nodes/instances/{workItemId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getNodeInstanceForWorkItem(@Context HttpHeaders headers, @ApiParam(value="process instance id that work item belongs to", required=true) @PathParam(value="pInstanceId") long processInstanceId, @ApiParam(value="work item id to retrieve node instance for", required=true) @PathParam(value="workItemId") long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        NodeInstance nodeInstanceDesc = null;
        try {
            nodeInstanceDesc = this.runtimeDataServiceBase.getNodeInstanceForWorkItem(processInstanceId, workItemId);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", workItemId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)nodeInstanceDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves node instances for given process instance. Depending on provided query parameters (activeOnly or completedOnly) will return active and/or completes nodes", response=NodeInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/instances/{pInstanceId}/nodes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceHistory(@Context HttpHeaders headers, @ApiParam(value="process instance id to to retrive history for", required=true) @PathParam(value="pInstanceId") long processInstanceId, @ApiParam(value="include active nodes only", required=false) @QueryParam(value="activeOnly") Boolean active, @ApiParam(value="include completed nodes only", required=false) @QueryParam(value="completedOnly") Boolean completed, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        NodeInstanceList nodeInstanceList = this.runtimeDataServiceBase.getProcessInstanceHistory(processInstanceId, active, completed, page, pageSize);
        logger.debug("Returning result of node instances search: {}", (Object)nodeInstanceList);
        return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves variables last value (from audit logs) for given process instance", response=VariableInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/instances/{pInstanceId}/variables/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getVariablesCurrentState(@Context HttpHeaders headers, @ApiParam(value="process instance id to load variables current state (latest value) for", required=true) @PathParam(value="pInstanceId") long processInstanceId) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariablesCurrentState(processInstanceId);
        logger.debug("Returning result of variables search: {}", (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves variable history (from audit logs) for given variable name that belongs to process instance", response=VariableInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/instances/{pInstanceId}/variables/instances/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getVariableHistory(@Context HttpHeaders headers, @ApiParam(value="process instance id to load variable history for", required=true) @PathParam(value="pInstanceId") long processInstanceId, @ApiParam(value="variable name that history should be loaded for", required=true) @PathParam(value="varName") String variableName, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariableHistory(processInstanceId, variableName, page, pageSize);
        logger.debug("Returning result of variable '{}; history search: {}", (Object)variableName, (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process definitions that belong to given container", response=ProcessDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="containers/{id}/processes/definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByDeploymentId(@Context HttpHeaders headers, @ApiParam(value="container id to filter process definitions", required=true) @PathParam(value="id") String containerId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesByDeploymentId(containerId, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process definitions filtered by process id or name", response=ProcessDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByFilter(@Context HttpHeaders headers, @ApiParam(value="process id or name to filter process definitions", required=false) @QueryParam(value="filter") String filter, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesByFilter(filter, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process definitions filtered by process id", response=ProcessDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="processes/definitions/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesById(@Context HttpHeaders headers, @ApiParam(value="process id to load process definition", required=true) @PathParam(value="pId") String processId) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesById(processId);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves process definition that belong to given container and has matching process id", response=ProcessDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="containers/{id}/processes/definitions/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByDeploymentIdProcessId(@Context HttpHeaders headers, @ApiParam(value="container id that process definition belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="process id to load process definition", required=true) @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinition processDesc = null;
        try {
            processDesc = this.runtimeDataServiceBase.getProcessesByDeploymentIdProcessId(containerId, processId);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Retrieves task by associated work item id", response=TaskInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task not found for given work item id")})
    @GET
    @Path(value="tasks/instances/workitem/{workItemId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskByWorkItemId(@Context HttpHeaders headers, @ApiParam(value="work item id to load task associated with", required=true) @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        TaskInstance userTaskDesc = null;
        try {
            userTaskDesc = this.runtimeDataServiceBase.getTaskByWorkItemId(workItemId.longValue());
            return RestUtils.createCorrectVariant((Object)userTaskDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance for work item with id \"{0}\"", workItemId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves task by task id", response=TaskInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task not found for given id")})
    @GET
    @Path(value="tasks/instances/{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskById(@Context HttpHeaders headers, @ApiParam(value="task id to load task instance", required=true) @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        TaskInstance userTaskDesc = null;
        try {
            userTaskDesc = this.runtimeDataServiceBase.getTaskById(taskId.longValue());
            return RestUtils.createCorrectVariant((Object)userTaskDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves tasks assigned as business administrator, optionally filters by status and applies pagination", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="tasks/instances/admins")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksAssignedAsBusinessAdministratorByStatus(@Context HttpHeaders headers, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksAssignedAsBusinessAdministratorByStatus(status, userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves tasks assigned as potential owner, optionally filters by status and given groups and applies pagination", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="tasks/instances/pot-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksAssignedAsPotentialOwner(@Context HttpHeaders headers, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional group names to include in the query", required=false, allowMultiple=true) @QueryParam(value="groups") List<String> groupIds, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @ApiParam(value="optional custom filter for task data", required=false) @QueryParam(value="filter") String filter) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksAssignedAsPotentialOwner(status, groupIds, userId, page, pageSize, sort, sortOrder, filter);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves tasks owned, optionally filters by status and applies pagination", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="tasks/instances/owners")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksOwnedByStatus(@Context HttpHeaders headers, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksOwnedByStatus(status, userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves tasks associated with given process instance, optionally filters by status and applies pagination", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="tasks/instances/process/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksByStatusByProcessInstanceId(@Context HttpHeaders headers, @ApiParam(value="process instance id to filter task instances", required=true) @PathParam(value="pInstanceId") Long processInstanceId, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksByStatusByProcessInstanceId((Number)processInstanceId, status, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves tasks with applied pagination", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="tasks/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getAllAuditTask(@Context HttpHeaders headers, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getAllAuditTask(userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves task events for given task id and applies pagination", response=TaskEventInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="tasks/instances/{tInstanceId}/events")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskEvents(@Context HttpHeaders headers, @ApiParam(value="task id to load task events for", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskEventInstanceList result = this.runtimeDataServiceBase.getTaskEvents(taskId.longValue(), page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves tasks by variable name and optionally by variable value, optionally filters by status and applies pagination", response=TaskSummaryList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="tasks/instances/variables/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksByVariables(@Context HttpHeaders headers, @ApiParam(value="name of the variable used to fiter tasks", required=true) @PathParam(value="varName") String variableName, @ApiParam(value="value of the variable used to fiter tasks, optional when filtering only by name, required when filtering by both name and value", required=false) @QueryParam(value="varValue") String variableValue, @ApiParam(value="optional task status (Created, Ready, Reserved, InProgress, Suspended, Completed, Failed, Error, Exited, Obsolete)", required=false, allowableValues="Created, Ready, Reserved,InProgress,Suspended,Completed,Failed,Error,Exited,Obsolete") @QueryParam(value="status") List<String> status, @ApiParam(value="optional user id to be used instead of authenticated user - only when bypass authenticated user is enabled", required=false) @QueryParam(value="user") String userId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksByVariables(userId, variableName, variableValue, status, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

