/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.swagger;

import io.swagger.models.Operation;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.remote.rest.common.marker.KieServerEndpoint;
import org.kie.server.remote.rest.swagger.ReadOnlySwaggerDecoration;

public class ReadOnlySwaggerDecorationTest {
    @Test
    public void testGetAlwaysPass() throws Exception {
        ReadOnlySwaggerDecoration decoration = new ReadOnlySwaggerDecoration();
        Operation operation = new Operation();
        decoration.decorateOperation(operation, TestSimpleOperations.class.getMethod("test1", new Class[0]), Collections.emptyListIterator());
        Assert.assertThat(operation.getVendorExtensions().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"x-readonly"}));
    }

    @Test
    public void testOtherOperationNoPass() throws Exception {
        ReadOnlySwaggerDecoration decoration = new ReadOnlySwaggerDecoration();
        Operation operation = new Operation();
        decoration.decorateOperation(operation, TestSimpleOperations.class.getMethod("test2", new Class[0]), Collections.emptyListIterator());
        Assert.assertThat(operation.getVendorExtensions().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{"x-readonly"})));
    }

    @Test
    public void testOtherNoPassAnnotationPass() throws Exception {
        ReadOnlySwaggerDecoration decoration = new ReadOnlySwaggerDecoration();
        Operation operation = new Operation();
        decoration.decorateOperation(operation, TestAnnotationOperations.class.getMethod("test1", new Class[0]), Collections.emptyListIterator());
        Assert.assertThat(operation.getVendorExtensions().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{"x-readonly"})));
    }

    @Test
    public void testOtherAlwaysPassAnnotationPass() throws Exception {
        ReadOnlySwaggerDecoration decoration = new ReadOnlySwaggerDecoration();
        Operation operation = new Operation();
        decoration.decorateOperation(operation, TestAnnotationOperations.class.getMethod("test2", new Class[0]), Collections.emptyListIterator());
        Assert.assertThat(operation.getVendorExtensions().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"x-readonly"}));
    }

    @Test
    public void testOtherOverrideBadPassAnnotationPass() throws Exception {
        ReadOnlySwaggerDecoration decoration = new ReadOnlySwaggerDecoration();
        Operation operation = new Operation();
        decoration.decorateOperation(operation, TestTypeAnnotationOperations.class.getMethod("test1", new Class[0]), Collections.emptyListIterator());
        Assert.assertThat(operation.getVendorExtensions().keySet(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new String[]{"x-readonly"})));
    }

    @Test
    public void testOtherTypePassAnnotationPass() throws Exception {
        ReadOnlySwaggerDecoration decoration = new ReadOnlySwaggerDecoration();
        Operation operation = new Operation();
        decoration.decorateOperation(operation, TestTypeAnnotationOperations.class.getMethod("test2", new Class[0]), Collections.emptyListIterator());
        Assert.assertThat(operation.getVendorExtensions().keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"x-readonly"}));
    }

    @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.HISTORY})
    static class TestTypeAnnotationOperations {
        TestTypeAnnotationOperations() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT})
        public void test1() {
        }

        public void test2() {
        }
    }

    static class TestAnnotationOperations {
        TestAnnotationOperations() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.DEFAULT})
        public void test1() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.ALWAYS})
        public void test2() {
        }

        @KieServerEndpoint(categories={KieServerEndpoint.EndpointType.HISTORY})
        public void test3() {
        }
    }

    static class TestSimpleOperations {
        TestSimpleOperations() {
        }

        @GET
        public void test1() {
        }

        @POST
        public void test2() {
        }
    }
}

