/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.casemgmt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.CaseService;
import org.jbpm.casemgmt.api.admin.CaseInstanceMigrationService;
import org.jbpm.casemgmt.api.auth.AuthorizationManager;
import org.jbpm.casemgmt.api.generator.CaseIdGenerator;
import org.jbpm.casemgmt.impl.AuthorizationManagerImpl;
import org.jbpm.casemgmt.impl.CaseRuntimeDataServiceImpl;
import org.jbpm.casemgmt.impl.CaseServiceImpl;
import org.jbpm.casemgmt.impl.admin.CaseInstanceMigrationServiceImpl;
import org.jbpm.casemgmt.impl.event.CaseConfigurationDeploymentListener;
import org.jbpm.casemgmt.impl.generator.TableCaseIdGenerator;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.casemgmt.CaseAdminServiceBase;
import org.kie.server.services.casemgmt.CaseKieContainerCommandServiceImpl;
import org.kie.server.services.casemgmt.CaseManagementRuntimeDataServiceBase;
import org.kie.server.services.casemgmt.CaseManagementServiceBase;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "Case-Mgmt";
    private static final Logger logger = LoggerFactory.getLogger(CaseKieServerExtension.class);
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.jbpm.case.server.ext.disabled", "false"));
    private static final Boolean jbpmDisabled = Boolean.parseBoolean(System.getProperty("org.jbpm.server.ext.disabled", "false"));
    protected String persistenceUnitName = "org.jbpm.domain";
    protected List<Object> services = new ArrayList<Object>();
    protected boolean initialized = false;
    protected KieServerRegistry registry;
    protected CaseManagementServiceBase caseManagementServiceBase;
    protected CaseManagementRuntimeDataServiceBase caseManagementRuntimeDataService;
    protected CaseAdminServiceBase caseAdminServiceBase;
    protected KieContainerCommandService kieContainerCommandService;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return disabled == false && jbpmDisabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.registry = registry;
        KieServerExtension jbpmExtension = registry.getServerExtension("jBPM");
        if (jbpmExtension == null) {
            this.initialized = false;
            logger.warn("jBPM extension not found, Case Management cannot work without jBPM extension, disabling itself");
            return;
        }
        this.configureServices(kieServer, registry);
        this.services.add(this.caseManagementServiceBase);
        this.services.add(this.caseManagementRuntimeDataService);
        this.kieContainerCommandService = new CaseKieContainerCommandServiceImpl(registry, this.caseManagementServiceBase, this.caseManagementRuntimeDataService, this.caseAdminServiceBase);
        this.initialized = true;
    }

    protected void configureServices(KieServerImpl kieServer, KieServerRegistry registry) {
        KieServerExtension jbpmExtension = registry.getServerExtension("jBPM");
        List jbpmServices = jbpmExtension.getServices();
        RuntimeDataService runtimeDataService = null;
        ProcessService processService = null;
        DeploymentService deploymentService = null;
        ProcessInstanceMigrationService processInstanceMigrationService = null;
        for (Object object : jbpmServices) {
            if (object == null) continue;
            if (RuntimeDataService.class.isAssignableFrom(object.getClass())) {
                runtimeDataService = (RuntimeDataService)object;
                continue;
            }
            if (ProcessService.class.isAssignableFrom(object.getClass())) {
                processService = (ProcessService)object;
                continue;
            }
            if (DeploymentService.class.isAssignableFrom(object.getClass())) {
                deploymentService = (DeploymentService)object;
                continue;
            }
            if (!ProcessInstanceMigrationService.class.isAssignableFrom(object.getClass())) continue;
            processInstanceMigrationService = (ProcessInstanceMigrationService)object;
        }
        CaseIdGenerator caseIdGenerator = this.getCaseIdGenerator();
        CaseRuntimeDataServiceImpl caseRuntimeDataService = new CaseRuntimeDataServiceImpl();
        caseRuntimeDataService.setCaseIdGenerator(caseIdGenerator);
        caseRuntimeDataService.setRuntimeDataService(runtimeDataService);
        caseRuntimeDataService.setCommandService(new TransactionalCommandService(EntityManagerFactoryManager.get().getOrCreate(this.persistenceUnitName)));
        caseRuntimeDataService.setIdentityProvider(registry.getIdentityProvider());
        CaseServiceImpl caseService = new CaseServiceImpl();
        caseService.setCaseIdGenerator(caseIdGenerator);
        caseService.setCaseRuntimeDataService((CaseRuntimeDataService)caseRuntimeDataService);
        caseService.setProcessService(processService);
        caseService.setDeploymentService(deploymentService);
        caseService.setRuntimeDataService(runtimeDataService);
        caseService.setCommandService(new TransactionalCommandService(EntityManagerFactoryManager.get().getOrCreate(this.persistenceUnitName)));
        caseService.setAuthorizationManager((AuthorizationManager)new AuthorizationManagerImpl(registry.getIdentityProvider(), new TransactionalCommandService(EntityManagerFactoryManager.get().getOrCreate(this.persistenceUnitName))));
        caseService.setIdentityProvider(registry.getIdentityProvider());
        CaseConfigurationDeploymentListener configurationListener = new CaseConfigurationDeploymentListener(registry.getIdentityProvider());
        ((KModuleDeploymentService)deploymentService).addListener((DeploymentEventListener)caseRuntimeDataService);
        ((KModuleDeploymentService)deploymentService).addListener((DeploymentEventListener)configurationListener);
        CaseInstanceMigrationServiceImpl caseInstanceMigrationService = new CaseInstanceMigrationServiceImpl();
        caseInstanceMigrationService.setCaseRuntimeDataService((CaseRuntimeDataService)caseRuntimeDataService);
        caseInstanceMigrationService.setCommandService(new TransactionalCommandService(EntityManagerFactoryManager.get().getOrCreate(this.persistenceUnitName)));
        caseInstanceMigrationService.setProcessInstanceMigrationService(processInstanceMigrationService);
        caseInstanceMigrationService.setProcessService(processService);
        this.caseManagementServiceBase = new CaseManagementServiceBase((CaseService)caseService, (CaseRuntimeDataService)caseRuntimeDataService, registry);
        this.caseManagementRuntimeDataService = new CaseManagementRuntimeDataServiceBase((CaseRuntimeDataService)caseRuntimeDataService, registry);
        this.caseAdminServiceBase = new CaseAdminServiceBase((CaseInstanceMigrationService)caseInstanceMigrationService, registry);
    }

    protected CaseIdGenerator getCaseIdGenerator() {
        String selectedGenerator = System.getProperty("org.kie.server.cases.generator");
        if (selectedGenerator == null) {
            return new TableCaseIdGenerator(new TransactionalCommandService(EntityManagerFactoryManager.get().getOrCreate(this.persistenceUnitName)));
        }
        ServiceLoader<CaseIdGenerator> generators = ServiceLoader.load(CaseIdGenerator.class);
        for (CaseIdGenerator generator : generators) {
            if (!generator.getIdentifier().equals(selectedGenerator)) continue;
            return generator;
        }
        throw new IllegalStateException("Unable to find case id generator identified by " + selectedGenerator);
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        if (!this.initialized) {
            return;
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
        this.disposeContainer(id, kieContainerInstance, parameters);
        this.createContainer(id, kieContainerInstance, parameters);
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        if (!this.initialized) {
            return;
        }
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        if (!this.initialized) {
            return appComponentsList;
        }
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        Object[] services = new Object[]{this.caseManagementServiceBase, this.caseManagementRuntimeDataService, this.caseAdminServiceBase, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (!this.initialized) {
            return null;
        }
        if (serviceType.isAssignableFrom(this.kieContainerCommandService.getClass())) {
            return (T)this.kieContainerCommandService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "CaseMgmt";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 10;
    }

    public String toString() {
        return "Case-Mgmt KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

