/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.server.api.KieController;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestControllerImpl
implements KieController {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRestControllerImpl.class);

    public Set<KieContainerResource> getContainers(Set<String> controllers, String serverId) {
        for (String controllerUrl : controllers) {
            if (controllerUrl == null || controllerUrl.isEmpty()) continue;
            String connectAndSyncUrl = controllerUrl + "/controller/server/" + KieServerEnvironment.getServerId();
            try {
                KieContainerResourceList containerResourceList = this.makeHttpGetRequestAndCreateServiceResponse(connectAndSyncUrl, KieContainerResourceList.class);
                if (containerResourceList != null) {
                    return new HashSet<KieContainerResource>(containerResourceList.getContainers());
                }
                break;
            }
            catch (Exception e) {
                logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
            }
        }
        return null;
    }

    private <T> T makeHttpGetRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        try {
            KieRemoteHttpRequest request = this.newRequest(uri).get();
            KieRemoteHttpResponse response = request.response();
            if (response.code() == Response.Status.OK.getStatusCode()) {
                KieContainerResourceList serviceResponse = this.deserialize(response.body(), KieContainerResourceList.class);
                return (T)serviceResponse;
            }
            throw new IllegalStateException("No response from controller server at " + uri);
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("No response from controller server at " + uri);
        }
    }

    private KieRemoteHttpRequest newRequest(String uri) {
        KieRemoteHttpRequest httpRequest = KieRemoteHttpRequest.newRequest((String)uri).followRedirects(true).timeout(5000L);
        httpRequest.accept("application/json");
        httpRequest.basicAuthorization(KieServerEnvironment.getUsername(), KieServerEnvironment.getPassword());
        return httpRequest;
    }

    private <T> T deserialize(String content, Class<T> type) {
        try {
            return (T)MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()).unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while deserializing data received from server!", e);
        }
    }
}

