/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.KieController;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.Version;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.DefaultRestControllerImpl;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.security.JACCIdentityProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerImpl {
    private static final Logger logger = LoggerFactory.getLogger(KieServerImpl.class);
    private static final ServiceLoader<KieServerExtension> serverExtensions = ServiceLoader.load(KieServerExtension.class);
    private static final ServiceLoader<KieController> kieControllers = ServiceLoader.load(KieController.class);
    private final KieServerRegistry context = new KieServerRegistryImpl();
    private final KieServerStateRepository repository;

    public KieServerImpl() {
        this.context.registerIdentityProvider(new JACCIdentityProvider());
        this.repository = new KieServerStateFileRepository();
        KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
        for (KieServerExtension extension : serverExtensions) {
            if (!extension.isActive()) continue;
            try {
                extension.init(this, this.context);
                this.context.registerServerExtension(extension);
                logger.info("{} has been successfully registered as server extension", (Object)extension);
            }
            catch (Exception e) {
                logger.error("Error when initializing server extension of type {}", (Object)extension, (Object)e);
            }
        }
        Set<String> controllers = currentState.getControllers();
        KieController kieController = this.getController();
        Set<KieContainerResource> containers = kieController.getContainers(controllers, KieServerEnvironment.getServerId());
        if (containers == null || containers.isEmpty()) {
            containers = currentState.getContainers();
        }
        for (KieContainerResource containerResource : containers) {
            this.createContainer(containerResource.getContainerId(), containerResource);
        }
        this.repository.store(KieServerEnvironment.getServerId(), currentState);
    }

    public KieServerRegistry getServerRegistry() {
        return this.context;
    }

    public ServiceResponse<KieServerInfo> registerController(String controller, KieServerConfig kieServerConfig) {
        if (controller != null && !controller.isEmpty()) {
            this.context.registerController(controller);
            KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
            currentState.setControllers(this.context.getControllers());
            currentState.setConfiguration(kieServerConfig);
            this.repository.store(KieServerEnvironment.getServerId(), currentState);
        }
        return this.getInfo();
    }

    public void destroy() {
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            try {
                extension.destroy(this, this.context);
                this.context.unregisterServerExtension(extension);
                logger.info("{} has been successfully unregistered as server extension", (Object)extension);
            }
            catch (Exception e) {
                logger.error("Error when destroying server extension of type {}", (Object)extension, (Object)e);
            }
        }
    }

    public List<KieServerExtension> getServerExtensions() {
        return this.context.getServerExtensions();
    }

    public ServiceResponse<KieServerInfo> getInfo() {
        try {
            Version version = KieServerEnvironment.getVersion();
            String serverId = KieServerEnvironment.getServerId();
            String versionStr = version != null ? version.toString() : "Unknown-Version";
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie Server info", (Object)new KieServerInfo(serverId, versionStr));
        }
        catch (Exception e) {
            logger.error("Error retrieving server info:", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving kie server info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public ServiceResponse<KieContainerResource> createContainer(String containerId, KieContainerResource container) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK], 6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ServiceResponse<KieContainerResourceList> listContainers() {
        try {
            ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
            for (KieContainerInstanceImpl instance : this.context.getContainers()) {
                containers.add(instance.getResource());
            }
            KieContainerResourceList cil = new KieContainerResourceList(containers);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "List of created containers", (Object)cil);
        }
        catch (Exception e) {
            logger.error("Error retrieving list of containers", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error listing containers: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                if (ci.getResource().getScanner() == null) {
                    ci.getResource().setScanner(this.getScannerResource(ci));
                }
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Info for container " + id, (Object)ci.getResource());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving info for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<Void> disposeContainer(String containerId) {
        try {
            KieContainerInstanceImpl kci = this.context.unregisterContainer(containerId);
            if (kci != null) {
                KieContainerInstanceImpl kieContainerInstanceImpl = kci;
                synchronized (kieContainerInstanceImpl) {
                    kci.setStatus(KieContainerStatus.DISPOSING);
                    if (kci.getKieContainer() != null) {
                        InternalKieContainer kieContainer = kci.getKieContainer();
                        kci.setKieContainer(null);
                        try {
                            kieContainer.dispose();
                            logger.debug("Container {} (for release id {}) general shutdown: DONE", (Object)containerId, (Object)kci.getResource().getReleaseId());
                            List<KieServerExtension> extensions = this.context.getServerExtensions();
                            for (KieServerExtension extension : extensions) {
                                extension.disposeContainer(containerId, new HashMap<String, Object>());
                                logger.debug("Container {} (for release id {}) {} shutdown: DONE", new Object[]{containerId, kci.getResource().getReleaseId(), extension});
                            }
                        }
                        catch (Exception e) {
                            logger.warn("Container '" + containerId + "' disposed, but an unexpected exception was raised", (Throwable)e);
                            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " disposed, but exception was raised: " + e.getClass().getName() + ": " + e.getMessage());
                        }
                        logger.info("Container {} (for release id {}) successfully stopped", (Object)containerId, (Object)kci.getResource().getReleaseId());
                        KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
                        ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
                        for (KieContainerResource containerResource : currentState.getContainers()) {
                            if (containerId.equals(containerResource.getContainerId())) continue;
                            containers.add(containerResource);
                        }
                        currentState.setContainers(new HashSet<KieContainerResource>(containers));
                        this.repository.store(KieServerEnvironment.getServerId(), currentState);
                        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully disposed.");
                    }
                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " was not instantiated.");
                }
            }
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " was not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error disposing Container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error disposing container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                KieScannerResource info = this.getScannerResource(kci);
                kci.getResource().setScanner(info);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scanner info successfully retrieved", (Object)info);
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error retrieving scanner info for container '" + id + "'.", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving scanner info for container '" + id + "': " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerResource getScannerResource(KieContainerInstanceImpl kci) {
        InternalKieScanner scanner = kci.getScanner();
        KieScannerResource info = null;
        info = scanner != null ? new KieScannerResource(this.mapStatus(scanner.getStatus()), Long.valueOf(scanner.getPollingInterval())) : new KieScannerResource(KieScannerStatus.DISPOSED);
        return info;
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (resource == null || resource.getStatus() == null) {
            logger.error("Error updating scanner for container " + id + ". Status is null: " + resource);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container " + id + ". Status is null: " + resource);
        }
        KieScannerStatus status = resource.getStatus();
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                ServiceResponse result = null;
                switch (status) {
                    case CREATED: {
                        result = this.createScanner(id, kci);
                        break;
                    }
                    case STARTED: {
                        result = this.startScanner(id, resource, kci);
                        break;
                    }
                    case STOPPED: {
                        result = this.stopScanner(id, resource, kci);
                        break;
                    }
                    case SCANNING: {
                        result = this.scanNow(id, resource, kci);
                        break;
                    }
                    case DISPOSED: {
                        result = this.disposeScanner(id, resource, kci);
                        break;
                    }
                    default: {
                        result = new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown status '" + status + "' for scanner on container " + id + ".");
                    }
                }
                kci.getResource().setScanner((KieScannerResource)result.getResult());
                return result;
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error updating scanner for container '" + id + "': " + resource, (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container '" + id + "': " + resource + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private ServiceResponse<KieScannerResource> startScanner(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        if (kci.getScanner() == null && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.createScanner(id, kci)).getType())) {
            return response;
        }
        if (KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) && resource.getPollInterval() != null) {
            kci.getScanner().start(resource.getPollInterval().longValue());
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        if (!KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)this.getScannerResource(kci));
        }
        if (resource.getPollInterval() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid polling interval: " + resource.getPollInterval(), (Object)this.getScannerResource(kci));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown error starting scanner. Scanner was not started." + resource, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> stopScanner(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid call. Scanner is not instantiated. ", (Object)this.getScannerResource(kci));
        }
        if (KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            kci.getScanner().stop();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully stopped.", (Object)this.getScannerResource(kci));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + this.mapStatus(kci.getScanner().getStatus()), (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> scanNow(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        KieScannerStatus kss;
        if (kci.getScanner() == null) {
            this.createScanner(id, kci);
        }
        if (KieScannerStatus.STOPPED.equals((Object)(kss = this.mapStatus(kci.getScanner().getStatus()))) || KieScannerStatus.CREATED.equals((Object)kss) || KieScannerStatus.STARTED.equals((Object)kss)) {
            kci.getScanner().scanNow();
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scan successfully executed.", (Object)this.getScannerResource(kci));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + kss, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> disposeScanner(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Invalid call. Scanner already disposed. ", (Object)this.getScannerResource(kci));
        }
        if ((KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.stopScanner(id, resource, kci)).getType())) {
            return response;
        }
        kci.getScanner().shutdown();
        kci.setScanner(null);
        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully shutdown.", (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> createScanner(String id, KieContainerInstanceImpl kci) {
        if (kci.getScanner() == null) {
            InternalKieScanner scanner = (InternalKieScanner)KieServices.Factory.get().newKieScanner((KieContainer)kci.getKieContainer());
            kci.setScanner(scanner);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating the scanner for container " + id + ". Scanner already exists.");
    }

    public ServiceResponse<ReleaseId> getContainerReleaseId(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "ReleaseId for container " + id, (Object)ci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container releaseId: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<ReleaseId> updateContainerReleaseId(String id, ReleaseId releaseId) {
        if (releaseId == null) {
            logger.error("Error updating releaseId for container '" + id + "'. ReleaseId is null.");
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ". ReleaseId is null. ");
        }
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                Results results = kci.getKieContainer().updateToVersion((org.kie.api.builder.ReleaseId)releaseId);
                if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                    logger.error("Error updating releaseId for container " + id + " to version " + releaseId + "\nMessages: " + results.getMessages());
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating release id on container " + id + " to " + releaseId, (Object)kci.getResource().getReleaseId());
                }
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error updating releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerStatus mapStatus(InternalKieScanner.Status status) {
        switch (status) {
            case STARTING: {
                return KieScannerStatus.CREATED;
            }
            case RUNNING: {
                return KieScannerStatus.STARTED;
            }
            case SCANNING: 
            case UPDATING: {
                return KieScannerStatus.SCANNING;
            }
            case STOPPED: {
                return KieScannerStatus.STOPPED;
            }
            case SHUTDOWN: {
                return KieScannerStatus.DISPOSED;
            }
        }
        return KieScannerStatus.UNKNOWN;
    }

    protected KieController getController() {
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl();
        Iterator<KieController> it = kieControllers.iterator();
        if (it != null && it.hasNext()) {
            controller = it.next();
        }
        return controller;
    }
}

