/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage.file;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;

public class KieServerStateFileRepository
implements KieServerStateRepository {
    private static final String REPOSITORY_DIR = System.getProperty("org.kie.server.repo", ".");
    private XStream xs = new XStream();
    private Map<String, KieServerState> knownStates = new ConcurrentHashMap<String, KieServerState>();

    public KieServerStateFileRepository() {
        this.xs.alias("kie-server-state", KieServerState.class);
        this.xs.alias("container", KieContainerResource.class);
        this.xs.alias("config-item", KieServerConfigItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void store(String serverId, KieServerState kieServerState) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(REPOSITORY_DIR + File.separator + serverId + ".xml");
            this.xs.toXML((Object)kieServerState, (OutputStream)fos);
        }
        catch (IOException ex) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        this.knownStates.put(serverId, kieServerState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieServerState load(String serverId) {
        if (this.knownStates.containsKey(serverId)) {
            return this.knownStates.get(serverId);
        }
        Map<String, KieServerState> map = this.knownStates;
        synchronized (map) {
            File serverStateFile = new File(REPOSITORY_DIR + File.separator + serverId + ".xml");
            KieServerState kieServerState = new KieServerState();
            if (serverStateFile.exists()) {
                kieServerState = (KieServerState)this.xs.fromXML(serverStateFile);
            }
            this.knownStates.put(serverId, kieServerState);
            return kieServerState;
        }
    }
}

