/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.controller;

import java.net.URLEncoder;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestControllerImpl
implements KieServerController {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRestControllerImpl.class);
    private final KieServerRegistry context;

    public DefaultRestControllerImpl(KieServerRegistry context) {
        this.context = context;
    }

    protected <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, String user, String password) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri, user, password).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw new IllegalStateException("Error while sending PUT request to " + uri + " response code " + response.code());
    }

    protected <T> T makeHttpDeleteRequestAndCreateCustomResponse(String uri, Class<T> resultType, String user, String password) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri, user, password).delete();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.NO_CONTENT.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw new IllegalStateException("Error while sending DELETE request to " + uri + " response code " + response.code());
    }

    private KieRemoteHttpRequest newRequest(String uri, String userName, String password) {
        KieRemoteHttpRequest httpRequest = KieRemoteHttpRequest.newRequest((String)uri).followRedirects(true).timeout(5000L);
        httpRequest.accept("application/json");
        httpRequest.basicAuthorization(userName, password);
        return httpRequest;
    }

    private <T> T deserialize(String content, Class<T> type) {
        if (type == null) {
            return null;
        }
        try {
            return (T)MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()).unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while deserializing data received from server!", e);
        }
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()).marshall(object);
        }
        catch (MarshallingException e) {
            throw new IllegalStateException("Error while serializing request data!", e);
        }
    }

    public KieServerSetup connect(KieServerInfo serverInfo) {
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set<String> controllers = currentState.getControllers();
        KieServerConfig config = currentState.getConfiguration();
        if (controllers != null && !controllers.isEmpty()) {
            for (String controllerUrl : controllers) {
                if (controllerUrl == null || controllerUrl.isEmpty()) continue;
                String connectAndSyncUrl = controllerUrl + "/server/" + KieServerEnvironment.getServerId();
                String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
                String password = config.getConfigItemValue("org.kie.server.controller.pwd", "kieserver1!");
                try {
                    KieServerSetup kieServerSetup = this.makeHttpPutRequestAndCreateCustomResponse(connectAndSyncUrl, this.serialize(serverInfo), KieServerSetup.class, userName, password);
                    if (kieServerSetup != null) {
                        return kieServerSetup;
                    }
                    break;
                }
                catch (Exception e) {
                    logger.warn("Exception encountered while syncing with controller at {} error {}", (Object)connectAndSyncUrl, (Object)(e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
                    logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
                }
            }
            throw new KieControllerNotConnectedException("Unable to connect to any controller");
        }
        throw new KieControllerNotDefinedException("Unable to connect to any controller");
    }

    public void disconnect(KieServerInfo serverInfo) {
        KieServerState currentState = this.context.getStateRepository().load(KieServerEnvironment.getServerId());
        Set<String> controllers = currentState.getControllers();
        KieServerConfig config = currentState.getConfiguration();
        for (String controllerUrl : controllers) {
            if (controllerUrl == null || controllerUrl.isEmpty()) continue;
            String connectAndSyncUrl = null;
            try {
                connectAndSyncUrl = controllerUrl + "/server/" + KieServerEnvironment.getServerId() + "/?location=" + URLEncoder.encode(serverInfo.getLocation(), "UTF-8");
                String userName = config.getConfigItemValue("org.kie.server.controller.user", "kieserver");
                String password = config.getConfigItemValue("org.kie.server.controller.pwd", "kieserver1!");
                this.makeHttpDeleteRequestAndCreateCustomResponse(connectAndSyncUrl, null, userName, password);
                break;
            }
            catch (Exception e) {
                logger.debug("Exception encountered while syncing with controller at {} error {}", new Object[]{connectAndSyncUrl, e.getMessage(), e});
            }
        }
    }
}

