/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security.adapters;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.RealmCallback;
import org.kie.server.api.security.SecurityAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSSecurityAdapter
implements SecurityAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JMSSecurityAdapter.class);
    private static final ServiceLoader<SecurityAdapter> securityAdapters = ServiceLoader.load(SecurityAdapter.class);
    private static ThreadLocal<UserDetails> currentUser = new ThreadLocal();

    public String getUser(Object ... params) {
        if (currentUser.get() != null) {
            logger.debug("Returning name from JMS Adapter - {}", (Object)currentUser.get().getName());
            return currentUser.get().getName();
        }
        return null;
    }

    public List<String> getRoles(Object ... params) {
        if (currentUser.get() != null) {
            logger.debug("Returning name from JMS Adapter - {}", (Object)currentUser.get().getName());
            return currentUser.get().getRoles();
        }
        return Collections.emptyList();
    }

    public static void login(String user, String pass) {
        if (currentUser.get() != null) {
            logger.debug("Already authenticated with user {}", (Object)currentUser.get().getName());
            return;
        }
        logger.debug("About to login as {} with pass {}", (Object)user, (Object)pass.length());
        try {
            UserPassCallbackHandler handler = new UserPassCallbackHandler(user, pass);
            String domain = System.getProperty("org.kie.server.domain", "kie-jms-login-context");
            LoginContext lc = new LoginContext(domain, handler);
            lc.login();
            Subject subject = lc.getSubject();
            logger.debug("Login successfull and subject is {}", (Object)subject);
            UserDetails userDetails = new UserDetails();
            userDetails.setName(user);
            ArrayList<String> roles = new ArrayList<String>();
            if (subject != null) {
                Set<Principal> principals = subject.getPrincipals();
                if (principals != null) {
                    roles = new ArrayList();
                    for (Principal principal : principals) {
                        if (!(principal instanceof Group)) continue;
                        Enumeration groups = ((Group)principal).members();
                        while (groups.hasMoreElements()) {
                            Principal groupPrincipal = (Principal)groups.nextElement();
                            roles.add(groupPrincipal.getName());
                        }
                        break block2;
                    }
                }
                roles.addAll(JMSSecurityAdapter.getRolesFromAdapter(subject));
            }
            userDetails.setRoles(roles);
            logger.debug("setting user details as {}", (Object)userDetails);
            currentUser.set(userDetails);
        }
        catch (Exception e) {
            logger.error("Unable to login via JAAS with message supplied user and password", (Throwable)e);
        }
    }

    public static void logout() {
        currentUser.set(null);
    }

    protected static List<String> getRolesFromAdapter(Subject subject) {
        ArrayList<String> roles = new ArrayList<String>();
        for (SecurityAdapter adapter : securityAdapters) {
            List adapterRoles = adapter.getRoles(new Object[]{subject});
            if (adapterRoles == null || adapterRoles.isEmpty()) continue;
            roles.addAll(adapterRoles);
        }
        return roles;
    }

    private static class UserPassCallbackHandler
    implements CallbackHandler {
        private String user;
        private String pass;

        public UserPassCallbackHandler(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.user);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.pass.toCharArray());
                    continue;
                }
                if (!(current instanceof RealmCallback)) continue;
                RealmCallback realmCallback = (RealmCallback)current;
                realmCallback.setText(realmCallback.getDefaultText());
            }
        }
    }

    private static class UserDetails {
        private String name;
        private List<String> roles;

        private UserDetails() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String toString() {
            return "UserDetails{name='" + this.name + '\'' + ", roles=" + this.roles + '}';
        }
    }
}

