/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.security.adapters;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.kie.server.api.security.SecurityAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeblogicSecurityAdapter
implements SecurityAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WeblogicSecurityAdapter.class);
    private Class webLogicSecurity;
    private boolean active;

    public WeblogicSecurityAdapter() {
        try {
            this.webLogicSecurity = Class.forName("weblogic.security.Security");
            this.active = true;
        }
        catch (Exception e) {
            this.active = false;
            logger.debug("Unable to find weblogic.security.Security, disabling weblogic adapter");
        }
    }

    public String getUser(Object ... params) {
        if (this.active) {
            try {
                Subject wlsSubject = this.getSubject(params);
                if (wlsSubject != null) {
                    for (Principal p : wlsSubject.getPrincipals()) {
                        if (p.getClass().getName().indexOf("WLSUser") == -1) continue;
                        return p.getName();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to get user from subject due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    public List<String> getRoles(Object ... params) {
        ArrayList<String> proles = new ArrayList<String>();
        if (this.active) {
            try {
                Subject wlsSubject = this.getSubject(params);
                if (wlsSubject != null) {
                    for (Principal p : wlsSubject.getPrincipals()) {
                        if (p.getClass().getName().indexOf("WLSGroup") == -1) continue;
                        proles.add(p.getName());
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to get groups from subject due to {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return proles;
    }

    protected Object invoke(Object o, String method) {
        try {
            Method m = o.getClass().getDeclaredMethod(method, new Class[0]);
            return m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Subject getSubject(Object[] params) throws Exception {
        if (params != null && params.length > 0) {
            for (Object p : params) {
                if (!(p instanceof Subject)) continue;
                return (Subject)p;
            }
        }
        Method method = this.webLogicSecurity.getMethod("getCurrentSubject", new Class[0]);
        Subject wlsSubject = (Subject)method.invoke(null, new Object[0]);
        return wlsSubject;
    }
}

