/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.api.KieContainerInstance;

public class KieContainerInstanceImpl
implements KieContainerInstance {
    private KieContainerResource resource;
    private InternalKieContainer kieContainer;
    private InternalKieScanner scanner;
    private transient Map<MarshallingFormat, Marshaller> marshallers;
    private transient Map<String, Object> serviceContainer;
    private transient Set<Class<?>> extraJaxbClasses = new HashSet();

    public KieContainerInstanceImpl(String containerId, KieContainerStatus status) {
        this(containerId, status, null);
    }

    public KieContainerInstanceImpl(String containerId, KieContainerStatus status, InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
        this.resource = new KieContainerResource(containerId, null, status);
        this.marshallers = new ConcurrentHashMap<MarshallingFormat, Marshaller>();
        this.serviceContainer = new ConcurrentHashMap<String, Object>();
        this.updateReleaseId();
    }

    @Override
    public String getContainerId() {
        return this.resource.getContainerId();
    }

    public void setContainerId(String containerId) {
        this.resource.setContainerId(containerId);
    }

    public InternalKieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
        this.updateReleaseId();
    }

    @Override
    public KieContainerStatus getStatus() {
        return this.resource.getStatus();
    }

    public void setStatus(KieContainerStatus status) {
        this.resource.setStatus(status);
    }

    @Override
    public KieContainerResource getResource() {
        this.updateReleaseId();
        return this.resource;
    }

    public void setResource(KieContainerResource resource) {
        this.resource = resource;
    }

    public void setScanner(InternalKieScanner scanner) {
        this.scanner = scanner;
    }

    public InternalKieScanner getScanner() {
        return this.scanner;
    }

    private void updateReleaseId() {
        if (this.kieContainer != null) {
            this.resource.setReleaseId(new ReleaseId(this.kieContainer.getContainerReleaseId()));
            this.resource.setResolvedReleaseId(new ReleaseId(this.kieContainer.getReleaseId()));
        }
        this.disposeMarshallers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Marshaller getMarshaller(MarshallingFormat format) {
        Map<MarshallingFormat, Marshaller> map = this.marshallers;
        synchronized (map) {
            Marshaller marshaller = this.marshallers.get(format);
            if (marshaller == null) {
                marshaller = MarshallerFactory.getMarshaller(this.getExtraJaxbClasses(), (MarshallingFormat)format, (ClassLoader)this.kieContainer.getClassLoader());
                this.marshallers.put(format, marshaller);
            }
            return marshaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeMarshallers() {
        Map<MarshallingFormat, Marshaller> map = this.marshallers;
        synchronized (map) {
            for (Marshaller marshaller : this.marshallers.values()) {
                marshaller.dispose();
            }
            this.marshallers.clear();
        }
    }

    @Override
    public void addService(Object service) {
        if (service == null) {
            return;
        }
        if (this.serviceContainer.containsKey(service.getClass().getName())) {
            throw new IllegalStateException("Service " + service.getClass().getName() + " already exists");
        }
        this.serviceContainer.put(service.getClass().getName(), service);
    }

    @Override
    public boolean addJaxbClasses(Set<Class<?>> extraJaxbClassList) {
        return this.extraJaxbClasses.addAll(extraJaxbClassList);
    }

    @Override
    public void clearJaxbClasses() {
        this.extraJaxbClasses.clear();
    }

    @Override
    public Set<Class<?>> getExtraJaxbClasses() {
        return this.extraJaxbClasses;
    }

    @Override
    public <T> T getService(Class<T> serviceType) {
        return (T)this.serviceContainer.get(serviceType.getName());
    }

    @Override
    public <T> T removeService(Class<T> serviceType) {
        return (T)this.serviceContainer.remove(serviceType.getName());
    }

    public String toString() {
        return this.resource.toString();
    }
}

