/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.scanner.MavenRepository;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;

public class KieServerImplTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");
    private static final String KIE_SERVER_ID = "kie-server-impl-test";
    private static final String GROUP_ID = "org.kie.server.test";
    private static final String VERSION = "1.0.0.Final";
    private KieServerImpl kieServer;
    private org.kie.api.builder.ReleaseId releaseId;

    @Before
    public void setupKieServerImpl() throws Exception {
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR));
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
    }

    @Test
    public void testPersistScannerState() {
        String containerId = "persist-scanner-state";
        this.createEmptyKjar(containerId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, new ReleaseId(this.releaseId));
        this.kieServer.createContainer(containerId, kieContainerResource);
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        this.kieServer.updateScanner(containerId, kieScannerResource);
        KieServerStateFileRepository stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        KieServerState state = stateRepository.load(KIE_SERVER_ID);
        Set containers = state.getContainers();
        Assertions.assertThat((Iterable)containers).hasSize(1);
        KieContainerResource container = (KieContainerResource)containers.iterator().next();
        Assertions.assertThat((Object)container.getScanner()).isEqualTo((Object)kieScannerResource);
        KieScannerResource updatedKieScannerResource = new KieScannerResource(KieScannerStatus.DISPOSED);
        this.kieServer.updateScanner(containerId, updatedKieScannerResource);
        stateRepository = new KieServerStateFileRepository(REPOSITORY_DIR);
        state = stateRepository.load(KIE_SERVER_ID);
        containers = state.getContainers();
        Assertions.assertThat((Iterable)containers).hasSize(1);
        container = (KieContainerResource)containers.iterator().next();
        Assertions.assertThat((Object)container.getScanner()).isEqualTo((Object)updatedKieScannerResource);
    }

    @Test
    public void testCreateScannerWhenCreatingContainer() {
        String containerId = "scanner-state-when-creating-container";
        this.createEmptyKjar(containerId);
        KieContainerResource kieContainerResource = new KieContainerResource(containerId, new ReleaseId(this.releaseId));
        KieScannerResource kieScannerResource = new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(20000L));
        kieContainerResource.setScanner(kieScannerResource);
        ServiceResponse createResponse = this.kieServer.createContainer(containerId, kieContainerResource);
        Assertions.assertThat((Comparable)createResponse.getType()).isEqualTo((Object)ServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)createResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
        ServiceResponse getResponse = this.kieServer.getContainerInfo(containerId);
        Assertions.assertThat((Comparable)getResponse.getType()).isEqualTo((Object)ServiceResponse.ResponseType.SUCCESS);
        Assertions.assertThat((Object)((KieContainerResource)getResponse.getResult()).getScanner()).isEqualTo((Object)kieScannerResource);
    }

    private void createEmptyKjar(String artifactId) {
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        this.releaseId = kieServices.newReleaseId(GROUP_ID, artifactId, VERSION);
        KieModule kieModule = kieServices.newKieBuilder(kfs).buildAll().getKieModule();
        MavenRepository.getMavenRepository().installArtifact(this.releaseId, (InternalKieModule)kieModule, this.createPomFile(artifactId));
        kieServices.getRepository().addKieModule(kieModule);
    }

    private File createPomFile(String artifactId) {
        String pomContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>org.kie.server.test</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>1.0.0.Final</version>\n  <packaging>pom</packaging>\n</project>";
        try {
            File file = new File("target/" + artifactId + "-1.0.0.Final.pom");
            FileUtils.write((File)file, (CharSequence)pomContent);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

