/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.InitialContext;
import org.drools.compiler.kproject.xml.DependencyFilter;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.Version;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Severity;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.controller.ControllerConnectRunnable;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.policy.PolicyManager;
import org.kie.server.services.impl.security.JACCIdentityProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerImpl
implements KieServer {
    private static final Logger logger = LoggerFactory.getLogger(KieServerImpl.class);
    private static final ServiceLoader<KieServerExtension> serverExtensions = ServiceLoader.load(KieServerExtension.class);
    private static final ServiceLoader<KieServerController> kieControllers = ServiceLoader.load(KieServerController.class);
    private String kieServerLocation;
    private final KieServerRegistry context;
    private final PolicyManager policyManager;
    private final KieServerStateRepository repository;
    private volatile AtomicBoolean kieServerActive;
    private List<Message> serverMessages;
    private Map<String, List<Message>> containerMessages;

    public KieServerImpl() {
        this(new KieServerStateFileRepository());
    }

    public KieServerImpl(KieServerStateRepository stateRepository) {
        KieServerSetup kieServerSetup;
        Set containers;
        KieServerInfo kieServerInfo;
        boolean readyToRun;
        KieServerState currentState;
        ContainerManager containerManager;
        block11: {
            this.kieServerLocation = System.getProperty("org.kie.server.location", "http://localhost:8230/kie-server/services/rest/server");
            this.kieServerActive = new AtomicBoolean(false);
            this.serverMessages = new ArrayList<Message>();
            this.containerMessages = new ConcurrentHashMap<String, List<Message>>();
            this.repository = stateRepository;
            this.context = new KieServerRegistryImpl();
            this.context.registerIdentityProvider(new JACCIdentityProvider());
            this.context.registerStateRepository(this.repository);
            ContainerLocatorProvider.get();
            containerManager = this.getContainerManager();
            currentState = this.repository.load(KieServerEnvironment.getServerId());
            List<KieServerExtension> extensions = this.sortKnownExtensions();
            for (KieServerExtension extension : extensions) {
                if (!extension.isActive()) continue;
                try {
                    extension.init(this, this.context);
                    this.context.registerServerExtension(extension);
                    logger.info("{} has been successfully registered as server extension", (Object)extension);
                }
                catch (Exception e) {
                    this.serverMessages.add(new Message(Severity.ERROR, "Error when initializing server extension of type " + extension + " due to " + e.getMessage()));
                    logger.error("Error when initializing server extension of type {}", (Object)extension, (Object)e);
                }
            }
            this.policyManager = new PolicyManager();
            this.policyManager.start(this, this.context);
            this.kieServerActive.set(true);
            readyToRun = false;
            KieServerController kieController = this.getController();
            kieServerInfo = this.getInfoInternal();
            containers = null;
            kieServerSetup = null;
            try {
                kieServerSetup = kieController.connect(kieServerInfo);
                containers = kieServerSetup.getContainers();
                readyToRun = true;
            }
            catch (KieControllerNotDefinedException e) {
                containers = currentState.getContainers();
                kieServerSetup = new KieServerSetup();
                readyToRun = true;
            }
            catch (KieControllerNotConnectedException e) {
                readyToRun = false;
                logger.warn("Unable to connect to any controllers, delaying container installation until connection can be established");
                Thread connectToControllerThread = new Thread((Runnable)new ControllerConnectRunnable(this.kieServerActive, kieController, kieServerInfo, currentState, containerManager, this), "KieServer-ControllerConnect");
                connectToControllerThread.start();
                if (!Boolean.parseBoolean(currentState.getConfiguration().getConfigItemValue("org.kie.server.sync.deploy", "false"))) break block11;
                logger.info("Containers were requested to be deployed synchronously, holding application start...");
                try {
                    connectToControllerThread.join();
                }
                catch (InterruptedException e1) {
                    logger.debug("Interrupt exception when waiting for deployments");
                }
            }
        }
        if (readyToRun) {
            this.addServerStatusMessage(kieServerInfo);
            if (Boolean.parseBoolean(currentState.getConfiguration().getConfigItemValue("org.kie.server.sync.deploy", "false"))) {
                containerManager.installContainersSync(this, containers, currentState, kieServerSetup);
            } else {
                containerManager.installContainers(this, containers, currentState, kieServerSetup);
            }
        }
    }

    public KieServerRegistry getServerRegistry() {
        return this.context;
    }

    public void destroy() {
        this.kieServerActive.set(false);
        this.policyManager.stop();
        KieServerController kieController = this.getController();
        kieController.disconnect(this.getInfoInternal());
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            try {
                extension.destroy(this, this.context);
                this.context.unregisterServerExtension(extension);
                logger.info("{} has been successfully unregistered as server extension", (Object)extension);
            }
            catch (Exception e) {
                logger.error("Error when destroying server extension of type {}", (Object)extension, (Object)e);
            }
        }
    }

    public List<KieServerExtension> getServerExtensions() {
        return this.context.getServerExtensions();
    }

    protected KieServerInfo getInfoInternal() {
        Version version = KieServerEnvironment.getVersion();
        String serverId = KieServerEnvironment.getServerId();
        String serverName = KieServerEnvironment.getServerName();
        String versionStr = version != null ? version.toString() : "Unknown-Version";
        ArrayList<String> capabilities = new ArrayList<String>();
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            capabilities.add(extension.getImplementedCapability());
        }
        return new KieServerInfo(serverId, serverName, versionStr, capabilities, this.kieServerLocation);
    }

    @Override
    public ServiceResponse<KieServerInfo> getInfo() {
        try {
            KieServerInfo kieServerInfo = this.getInfoInternal();
            kieServerInfo.setMessages(this.serverMessages);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie Server info", (Object)kieServerInfo);
        }
        catch (Exception e) {
            logger.error("Error retrieving server info:", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving kie server info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ServiceResponse<KieContainerResource> createContainer(String containerId, KieContainerResource container) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ServiceResponse<KieContainerResourceList> listContainers(KieContainerResourceFilter containerFilter) {
        try {
            ArrayList<KieContainerResource> filteredContainers = new ArrayList<KieContainerResource>();
            for (KieContainerResource container : this.getContainersWithMessages()) {
                if (!containerFilter.accept(container)) continue;
                filteredContainers.add(container);
            }
            KieContainerResourceList containerList = new KieContainerResourceList(filteredContainers);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "List of created containers", (Object)containerList);
        }
        catch (Exception e) {
            logger.error("Error retrieving list of containers", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error listing containers: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private List<KieContainerResource> getContainersWithMessages() {
        ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
        for (KieContainerInstanceImpl instance : this.context.getContainers()) {
            instance.getResource().setMessages(this.getMessagesForContainer(instance.getContainerId()));
            containers.add(instance.getResource());
        }
        return containers;
    }

    @Override
    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                this.setMessages(ci);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Info for container " + id, (Object)ci.getResource());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving info for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void setMessages(KieContainerInstanceImpl kci) {
        kci.getResource().setMessages(this.getMessagesForContainer(kci.getContainerId()));
    }

    /*
     * Exception decompiling
     */
    @Override
    public ServiceResponse<Void> disposeContainer(String containerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                KieScannerResource info = this.getScannerResource(kci);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scanner info successfully retrieved", (Object)info);
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error retrieving scanner info for container '" + id + "'.", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving scanner info for container '" + id + "': " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerResource getScannerResource(KieContainerInstanceImpl kci) {
        return kci.getResource().getScanner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (resource == null || resource.getStatus() == null) {
            logger.error("Error updating scanner for container " + id + ". Status is null: " + resource);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container " + id + ". Status is null: " + resource);
        }
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                KieContainerInstanceImpl kieContainerInstanceImpl = kci;
                synchronized (kieContainerInstanceImpl) {
                    ServiceResponse<KieScannerResource> scannerResponse = this.configureScanner(id, kci, resource);
                    this.storeScannerState(kci.getContainerId(), kci.getResource().getScanner());
                    return scannerResponse;
                }
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error updating scanner for container '" + id + "': " + resource, (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container '" + id + "': " + resource + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private ServiceResponse<KieScannerResource> configureScanner(String containerId, KieContainerInstanceImpl kci, KieScannerResource scannerResource) {
        ServiceResponse result;
        KieScannerStatus scannerStatus = scannerResource.getStatus();
        switch (scannerStatus) {
            case CREATED: {
                result = this.createScanner(containerId, kci);
                break;
            }
            case STARTED: {
                result = this.startScanner(containerId, scannerResource.getPollInterval(), kci);
                break;
            }
            case STOPPED: {
                result = this.stopScanner(containerId, kci);
                break;
            }
            case SCANNING: {
                result = this.scanNow(containerId, kci);
                break;
            }
            case DISPOSED: {
                result = this.disposeScanner(containerId, kci);
                break;
            }
            default: {
                result = new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown status '" + scannerStatus + "' for scanner on container " + containerId + ".");
            }
        }
        kci.getResource().setScanner((KieScannerResource)result.getResult());
        return result;
    }

    private void storeScannerState(String containerId, KieScannerResource scannerState) {
        KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
        for (KieContainerResource containerResource : currentState.getContainers()) {
            if (!containerId.equals(containerResource.getContainerId())) continue;
            containerResource.setScanner(scannerState);
        }
        this.repository.store(KieServerEnvironment.getServerId(), currentState);
    }

    private ServiceResponse<KieScannerResource> startScanner(String id, Long scannerPollInterval, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.createScanner(id, kci)).getType())) {
            return response;
        }
        KieScannerStatus scannerStatus = this.mapScannerStatus(kci);
        if (KieScannerStatus.STOPPED.equals((Object)scannerStatus) && scannerPollInterval != null) {
            kci.startScanner(scannerPollInterval);
            messages.add(new Message(Severity.INFO, "Kie scanner successfully started with interval " + scannerPollInterval));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        if (!KieScannerStatus.STOPPED.equals((Object)scannerStatus)) {
            messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + scannerStatus));
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + scannerStatus, (Object)this.getScannerResource(kci));
        }
        if (scannerPollInterval == null) {
            messages.add(new Message(Severity.WARN, "Invalid polling interval: null"));
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid polling interval: null", (Object)this.getScannerResource(kci));
        }
        messages.add(new Message(Severity.ERROR, "Unknown error starting scanner. Scanner was not started."));
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown error starting scanner. Scanner was not started.", (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> stopScanner(String id, KieContainerInstanceImpl kci) {
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scanner is not started. ", (Object)this.getScannerResource(kci));
        }
        if (KieScannerStatus.STARTED.equals((Object)this.mapScannerStatus(kci)) || KieScannerStatus.SCANNING.equals((Object)this.mapScannerStatus(kci))) {
            kci.stopScanner();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully stopped."));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully stopped.", (Object)this.getScannerResource(kci));
        }
        KieScannerStatus scannerStatus = this.mapScannerStatus(kci);
        messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + scannerStatus));
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + scannerStatus, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> scanNow(String id, KieContainerInstanceImpl kci) {
        KieScannerStatus scannerStatus;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            this.createScanner(id, kci);
        }
        if (KieScannerStatus.STOPPED.equals((Object)(scannerStatus = this.mapScannerStatus(kci))) || KieScannerStatus.CREATED.equals((Object)scannerStatus) || KieScannerStatus.STARTED.equals((Object)scannerStatus)) {
            kci.scanNow();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully invoked."));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scan successfully executed.", (Object)this.getScannerResource(kci));
        }
        messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + scannerStatus));
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + scannerStatus, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> disposeScanner(String id, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Invalid call. Scanner already disposed.", (Object)this.getScannerResource(kci));
        }
        if ((KieScannerStatus.STARTED.equals((Object)this.mapScannerStatus(kci)) || KieScannerStatus.SCANNING.equals((Object)this.mapScannerStatus(kci))) && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.stopScanner(id, kci)).getType())) {
            return response;
        }
        kci.disposeScanner();
        messages.add(new Message(Severity.INFO, "Kie scanner successfully disposed (shut down)."));
        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully disposed (shut down).", (Object)this.getScannerResource(kci));
    }

    private KieScannerStatus mapScannerStatus(KieContainerInstanceImpl kieContainerInstance) {
        return KieContainerInstanceImpl.mapScannerStatus(kieContainerInstance.getScanner().getStatus());
    }

    private ServiceResponse<KieScannerResource> createScanner(String id, KieContainerInstanceImpl kci) {
        if (kci.getScanner() == null) {
            List<Message> messages = this.getMessagesForContainer(id);
            messages.clear();
            kci.createScanner();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully created."));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating the scanner for container " + id + ". Scanner already exists.");
    }

    @Override
    public ServiceResponse<ReleaseId> getContainerReleaseId(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "ReleaseId for container " + id, (Object)ci.getRefreshedResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container releaseId: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public ServiceResponse<ReleaseId> updateContainerReleaseId(String id, ReleaseId releaseId) {
        if (releaseId == null) {
            logger.error("Error updating releaseId for container '" + id + "'. ReleaseId is null.");
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ". ReleaseId is null. ");
        }
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                KieModuleMetaData metaData = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.ReleaseId)releaseId, (DependencyFilter)DependencyFilter.COMPILE_FILTER);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("KieModuleMetaData", metaData);
                List<KieServerExtension> extensions = this.context.getServerExtensions();
                for (KieServerExtension extension : extensions) {
                    boolean allowed = extension.isUpdateContainerAllowed(id, kci, parameters);
                    if (!allowed) {
                        String message = (String)parameters.get("failure-reason");
                        logger.warn("Container {} (for release id {}) on {} cannot be updated due to {}", new Object[]{id, releaseId, extension, message});
                        if (messages != null) {
                            messages.add(new Message(Severity.WARN, message));
                        }
                        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, message);
                    }
                    logger.debug("Container {} (for release id {}) on {} ready to be updated", new Object[]{id, releaseId, extension});
                }
                kci.clearExtraClasses();
                kci.disposeMarshallers();
                Results results = kci.getKieContainer().updateToVersion((org.kie.api.builder.ReleaseId)releaseId);
                if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                    Message error = new Message(Severity.WARN, "Error updating releaseId for container " + id + " to version " + releaseId);
                    for (org.kie.api.builder.Message builderMsg : results.getMessages()) {
                        error.addMessage(builderMsg.getText());
                    }
                    messages.add(error);
                    logger.error("Error updating releaseId for container " + id + " to version " + releaseId + "\nMessages: " + results.getMessages());
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating release id on container " + id + " to " + releaseId, (Object)kci.getResource().getReleaseId());
                }
                kci.updateReleaseId();
                for (KieServerExtension extension : extensions) {
                    extension.updateContainer(id, kci, parameters);
                    logger.debug("Container {} (for release id {}) on {} updated successfully", new Object[]{id, releaseId, extension});
                }
                KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
                ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
                for (KieContainerResource containerResource : currentState.getContainers()) {
                    if (id.equals(containerResource.getContainerId())) {
                        containerResource.setReleaseId(releaseId);
                        containerResource.setResolvedReleaseId(new ReleaseId(kci.getKieContainer().getContainerReleaseId()));
                    }
                    containers.add(containerResource);
                }
                currentState.setContainers(new HashSet<KieContainerResource>(containers));
                this.repository.store(KieServerEnvironment.getServerId(), currentState);
                logger.info("Container {} successfully updated to release id {}", (Object)id, (Object)releaseId);
                messages.add(new Message(Severity.INFO, "Release id successfully updated for container " + id));
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            KieContainerResource containerResource = new KieContainerResource(id, releaseId, KieContainerStatus.STARTED);
            ServiceResponse<KieContainerResource> response = this.createContainer(id, containerResource);
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                kci = this.context.getContainer(id);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(new Message(Severity.WARN, "Error updating releaseId for container '" + id + "' due to " + e.getMessage()));
            }
            logger.error("Error updating releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public ServiceResponse<KieServerStateInfo> getServerState() {
        try {
            KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
            KieServerStateInfo state = new KieServerStateInfo(currentState.getControllers(), currentState.getConfiguration(), currentState.getContainers());
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Successfully loaded server state for server id " + KieServerEnvironment.getServerId(), (Object)state);
        }
        catch (Exception e) {
            logger.error("Error when loading server state due to {}", (Object)e.getMessage(), (Object)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error when loading server state due to " + e.getMessage());
        }
    }

    private Map<String, Object> getCreateContainerParameters(org.kie.api.builder.ReleaseId releaseId) {
        KieModuleMetaData metaData = KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.ReleaseId)releaseId, (DependencyFilter)DependencyFilter.COMPILE_FILTER);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("KieModuleMetaData", metaData);
        return parameters;
    }

    protected KieServerController getController() {
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl(this.context);
        Iterator<KieServerController> it = kieControllers.iterator();
        if (it != null && it.hasNext()) {
            controller = it.next();
        }
        return controller;
    }

    protected ContainerManager getContainerManager() {
        try {
            return (ContainerManager)InitialContext.doLookup("java:module/ContainerManagerEJB");
        }
        catch (Exception e) {
            logger.debug("Unable to find JEE version of ContainerManager suing default one");
            return new ContainerManager();
        }
    }

    protected List<KieServerExtension> sortKnownExtensions() {
        ArrayList<KieServerExtension> extensions = new ArrayList<KieServerExtension>();
        for (KieServerExtension extension : serverExtensions) {
            extensions.add(extension);
        }
        Collections.sort(extensions, new Comparator<KieServerExtension>(){

            @Override
            public int compare(KieServerExtension e1, KieServerExtension e2) {
                return e1.getStartOrder().compareTo(e2.getStartOrder());
            }
        });
        return extensions;
    }

    @Override
    public void addServerMessage(Message message) {
        this.serverMessages.add(message);
    }

    @Override
    public void addContainerMessage(String containerId, Message message) {
        List<Message> messages = this.getMessagesForContainer(containerId);
        messages.add(message);
    }

    public void addServerStatusMessage(KieServerInfo kieServerInfo) {
        StringBuilder serverInfoMsg = new StringBuilder();
        serverInfoMsg.append("Server ").append(kieServerInfo).append("started successfully at ").append(new Date());
        this.serverMessages.add(new Message(Severity.INFO, serverInfoMsg.toString()));
    }

    protected List<Message> getMessagesForContainer(String containerId) {
        List<Message> messages = this.containerMessages.get(containerId);
        if (messages == null) {
            messages = new CopyOnWriteArrayList<Message>();
            this.containerMessages.put(containerId, messages);
        }
        return messages;
    }

    public PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public String toString() {
        return "KieServer{id='" + KieServerEnvironment.getServerId() + '\'' + "name='" + KieServerEnvironment.getServerName() + '\'' + "version='" + KieServerEnvironment.getVersion() + '\'' + "location='" + this.kieServerLocation + '\'' + '}';
    }
}

