/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieSessionLookupManager;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;

public class KieServerRegistryImpl
implements KieServerRegistry {
    private final ConcurrentMap<String, KieContainerInstanceImpl> containers = new ConcurrentHashMap<String, KieContainerInstanceImpl>();
    private final ConcurrentMap<String, List<KieContainerInstanceImpl>> containersByAlias = new ConcurrentHashMap<String, List<KieContainerInstanceImpl>>();
    private IdentityProvider identityProvider;
    private ConcurrentMap<String, KieServerExtension> serverExtensions = new ConcurrentHashMap<String, KieServerExtension>();
    private Set<String> controllers = new CopyOnWriteArraySet<String>();
    private KieServerStateRepository repository;
    private KieSessionLookupManager kieSessionLookupManager = new KieSessionLookupManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieContainerInstanceImpl registerContainer(String id, KieContainerInstanceImpl kieContainerInstance) {
        ConcurrentMap<String, KieContainerInstanceImpl> concurrentMap = this.containers;
        synchronized (concurrentMap) {
            KieContainerInstanceImpl kci = this.containers.putIfAbsent(id, kieContainerInstance);
            if (kci != null && kci.getStatus() == KieContainerStatus.FAILED) {
                this.containers.put(id, kieContainerInstance);
                this.registerWithAlias(kieContainerInstance);
                return null;
            }
            this.registerWithAlias(kieContainerInstance);
            return kci;
        }
    }

    @Override
    public KieContainerInstanceImpl unregisterContainer(String id) {
        KieContainerInstanceImpl containerInstance = (KieContainerInstanceImpl)this.containers.remove(id);
        this.removeFromAlias(containerInstance);
        return containerInstance;
    }

    @Override
    public KieContainerInstanceImpl getContainer(String id) {
        return (KieContainerInstanceImpl)this.containers.get(id);
    }

    @Override
    public KieContainerInstanceImpl getContainer(String alias, ContainerLocator locator) {
        KieContainerInstanceImpl containerInstance = this.getContainer(alias);
        if (containerInstance == null) {
            String containerId = locator.locateContainer(alias, this.containersByAlias.getOrDefault(alias, new ArrayList()));
            if (containerId == null) {
                throw new IllegalArgumentException("Cannot find container for alias '" + alias + "'");
            }
            return this.getContainer(containerId);
        }
        return containerInstance;
    }

    @Override
    public String getContainerId(String alias, ContainerLocator locator) {
        KieContainerInstanceImpl kieContainerInstance = this.getContainer(alias, locator);
        if (kieContainerInstance == null) {
            return alias;
        }
        return kieContainerInstance.getContainerId();
    }

    @Override
    public List<KieContainerInstanceImpl> getContainers() {
        return new ArrayList<KieContainerInstanceImpl>(this.containers.values());
    }

    @Override
    public List<String> getContainerAliases() {
        return new ArrayList<String>(this.containersByAlias.keySet());
    }

    @Override
    public List<KieContainerInstanceImpl> getContainersForAlias(String alias) {
        return new ArrayList<KieContainerInstanceImpl>(this.containersByAlias.getOrDefault(alias, new ArrayList()));
    }

    @Override
    public void registerIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    @Override
    public IdentityProvider unregisterIdentityProvider() {
        IdentityProvider unregistered = this.identityProvider;
        this.identityProvider = null;
        return unregistered;
    }

    @Override
    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    @Override
    public void registerServerExtension(KieServerExtension kieServerExtension) {
        this.serverExtensions.putIfAbsent(kieServerExtension.getExtensionName(), kieServerExtension);
    }

    @Override
    public void unregisterServerExtension(KieServerExtension kieServerExtension) {
        this.serverExtensions.remove(kieServerExtension);
    }

    @Override
    public List<KieServerExtension> getServerExtensions() {
        ArrayList<KieServerExtension> extensions = new ArrayList<KieServerExtension>(this.serverExtensions.values());
        Collections.sort(extensions, new Comparator<KieServerExtension>(){

            @Override
            public int compare(KieServerExtension e1, KieServerExtension e2) {
                return e1.getStartOrder().compareTo(e2.getStartOrder());
            }
        });
        return extensions;
    }

    @Override
    public KieServerExtension getServerExtension(String extensionName) {
        return (KieServerExtension)this.serverExtensions.get(extensionName);
    }

    @Override
    public void registerController(String controllerUrl) {
        this.controllers.add(controllerUrl);
    }

    @Override
    public Set<String> getControllers() {
        return new HashSet<String>(this.controllers);
    }

    @Override
    public void registerStateRepository(KieServerStateRepository repository) {
        this.repository = repository;
    }

    @Override
    public KieServerStateRepository getStateRepository() {
        return this.repository;
    }

    @Override
    public KieSessionLookupManager getKieSessionLookupManager() {
        return this.kieSessionLookupManager;
    }

    @Override
    public KieServerConfig getConfig() {
        KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
        return currentState.getConfiguration();
    }

    protected void registerWithAlias(KieContainerInstanceImpl kieContainerInstance) {
        KieContainerResource containerResource = kieContainerInstance.getResource();
        String alias = this.getContainerAlias(containerResource);
        ArrayList<KieContainerInstanceImpl> byAlias = (ArrayList<KieContainerInstanceImpl>)this.containersByAlias.get(alias);
        if (byAlias == null) {
            byAlias = new ArrayList<KieContainerInstanceImpl>();
            this.containersByAlias.put(alias, byAlias);
        }
        byAlias.add(kieContainerInstance);
    }

    protected void removeFromAlias(KieContainerInstanceImpl kieContainerInstance) {
        if (kieContainerInstance == null) {
            return;
        }
        KieContainerResource containerResource = kieContainerInstance.getResource();
        String alias = this.getContainerAlias(containerResource);
        List byAlias = (List)this.containersByAlias.get(alias);
        if (byAlias != null) {
            byAlias.remove(kieContainerInstance);
        }
    }

    protected String getContainerAlias(KieContainerResource containerResource) {
        String alias = containerResource.getContainerAlias();
        if (alias == null || alias.isEmpty()) {
            alias = containerResource.getReleaseId().getArtifactId();
        }
        return alias;
    }
}

