/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.api.KieContainerInstance;

public class KieContainerInstanceImpl
implements KieContainerInstance {
    private KieContainerResource resource;
    private InternalKieContainer kieContainer;
    private InternalKieScanner scanner;
    private transient Map<MarshallingFormat, Marshaller> marshallers;
    private transient Map<String, Object> serviceContainer;
    private transient Set<Class<?>> extraClasses = new HashSet();

    public KieContainerInstanceImpl(String containerId, KieContainerStatus status) {
        this(containerId, status, null);
    }

    public KieContainerInstanceImpl(String containerId, KieContainerStatus status, InternalKieContainer kieContainer) {
        this(containerId, status, kieContainer, null);
    }

    public KieContainerInstanceImpl(String containerId, KieContainerStatus status, InternalKieContainer kieContainer, ReleaseId releaseId) {
        this.kieContainer = kieContainer;
        this.resource = new KieContainerResource(containerId, releaseId, status);
        this.resource.setScanner(new KieScannerResource(KieScannerStatus.DISPOSED));
        this.marshallers = new ConcurrentHashMap<MarshallingFormat, Marshaller>();
        this.serviceContainer = new ConcurrentHashMap<String, Object>();
        this.updateReleaseId();
    }

    public static KieScannerStatus mapScannerStatus(InternalKieScanner.Status status) {
        switch (status) {
            case STARTING: {
                return KieScannerStatus.CREATED;
            }
            case RUNNING: {
                return KieScannerStatus.STARTED;
            }
            case SCANNING: 
            case UPDATING: {
                return KieScannerStatus.SCANNING;
            }
            case STOPPED: {
                return KieScannerStatus.STOPPED;
            }
            case SHUTDOWN: {
                return KieScannerStatus.DISPOSED;
            }
        }
        return KieScannerStatus.UNKNOWN;
    }

    @Override
    public String getContainerId() {
        return this.resource.getContainerId();
    }

    public void setContainerId(String containerId) {
        this.resource.setContainerId(containerId);
    }

    public InternalKieContainer getKieContainer() {
        return this.kieContainer;
    }

    public void setKieContainer(InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
        this.updateReleaseId();
    }

    @Override
    public KieContainerStatus getStatus() {
        return this.resource.getStatus();
    }

    public void setStatus(KieContainerStatus status) {
        this.resource.setStatus(status);
    }

    @Override
    public KieContainerResource getResource() {
        this.updateReleaseId();
        return this.resource;
    }

    public void setResource(KieContainerResource resource) {
        this.resource = resource;
    }

    public InternalKieScanner getScanner() {
        return this.scanner;
    }

    public void createScanner() {
        this.scanner = (InternalKieScanner)KieServices.Factory.get().newKieScanner((KieContainer)this.kieContainer);
        KieScannerStatus status = KieContainerInstanceImpl.mapScannerStatus(this.scanner.getStatus());
        long pollingInterval = this.scanner.getPollingInterval();
        this.resource.setScanner(new KieScannerResource(status, Long.valueOf(pollingInterval)));
    }

    public void startScanner(long pollingInterval) {
        if (this.scanner == null) {
            throw new IllegalStateException("Can not start non-existing (null) scanner!");
        }
        this.scanner.start(pollingInterval);
        this.getResource().setScanner(new KieScannerResource(KieScannerStatus.STARTED, Long.valueOf(pollingInterval)));
    }

    public void scanNow() {
        if (this.scanner == null) {
            throw new IllegalStateException("Can not run (scanNow) non-existing (null) scanner!");
        }
        this.scanner.scanNow();
    }

    public void stopScanner() {
        if (this.scanner == null) {
            throw new IllegalStateException("Can not stop non-existing (null) scanner!");
        }
        this.scanner.stop();
        this.getResource().getScanner().setStatus(KieScannerStatus.STOPPED);
    }

    public void disposeScanner() {
        if (this.scanner == null) {
            throw new IllegalStateException("Can not dispose non-existing (null) scanner!");
        }
        this.scanner.shutdown();
        this.scanner = null;
        this.getResource().setScanner(new KieScannerResource(KieScannerStatus.DISPOSED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Marshaller getMarshaller(MarshallingFormat format) {
        Map<MarshallingFormat, Marshaller> map = this.marshallers;
        synchronized (map) {
            Marshaller marshaller = this.marshallers.get(format);
            if (marshaller == null) {
                marshaller = MarshallerFactory.getMarshaller(this.getExtraClasses(), (MarshallingFormat)format, (ClassLoader)this.kieContainer.getClassLoader());
                this.marshallers.put(format, marshaller);
            }
            return marshaller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeMarshallers() {
        Map<MarshallingFormat, Marshaller> map = this.marshallers;
        synchronized (map) {
            for (Marshaller marshaller : this.marshallers.values()) {
                marshaller.dispose();
            }
            this.marshallers.clear();
        }
    }

    @Override
    public void addService(Object service) {
        if (service == null) {
            return;
        }
        if (this.serviceContainer.containsKey(service.getClass().getName())) {
            throw new IllegalStateException("Service " + service.getClass().getName() + " already exists");
        }
        this.serviceContainer.put(service.getClass().getName(), service);
    }

    @Override
    public boolean addExtraClasses(Set<Class<?>> extraJaxbClassList) {
        return this.extraClasses.addAll(extraJaxbClassList);
    }

    @Override
    public void clearExtraClasses() {
        this.extraClasses.clear();
    }

    @Override
    public Set<Class<?>> getExtraClasses() {
        return this.extraClasses;
    }

    @Override
    public <T> T getService(Class<T> serviceType) {
        return (T)this.serviceContainer.get(serviceType.getName());
    }

    @Override
    public <T> T removeService(Class<T> serviceType) {
        return (T)this.serviceContainer.remove(serviceType.getName());
    }

    public String toString() {
        return this.resource.toString();
    }

    protected void updateReleaseId() {
        ReleaseId oldReleaseId = this.resource.getReleaseId();
        ReleaseId oldResolvedReleaseId = this.resource.getResolvedReleaseId();
        if (this.kieContainer != null) {
            this.resource.setReleaseId(new ReleaseId(this.kieContainer.getContainerReleaseId()));
            this.resource.setResolvedReleaseId(new ReleaseId(this.kieContainer.getReleaseId()));
        }
        if (this.releaseIdUpdated(oldReleaseId, this.resource.getReleaseId()) || this.releaseIdUpdated(oldResolvedReleaseId, this.resource.getResolvedReleaseId())) {
            this.disposeMarshallers();
        }
    }

    private boolean releaseIdUpdated(ReleaseId oldReleaseId, ReleaseId newReleaseId) {
        if (oldReleaseId == null && newReleaseId == null) {
            return false;
        }
        if (oldReleaseId == null && newReleaseId != null) {
            return true;
        }
        return !oldReleaseId.equals((Object)newReleaseId);
    }
}

