/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.policy;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.Policy;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.locator.LatestContainerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepLatestContainerOnlyPolicy
implements Policy {
    private static final Logger logger = LoggerFactory.getLogger(KeepLatestContainerOnlyPolicy.class);
    private static final String INTERVAL_VALUE = "policy.klo.interval";
    private static final String INTERVAL_TIME_UNIT = "policy.klo.unit";
    private static final String NAME = "KeepLatestOnly";
    private long interval;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void start() {
        logger.debug("Starting KeepLatestContainerOnlyPolicy policy...");
        TimeUnit timeUnit = TimeUnit.valueOf(System.getProperty(INTERVAL_TIME_UNIT, TimeUnit.MILLISECONDS.toString()));
        long givenInterval = Long.parseLong(System.getProperty(INTERVAL_VALUE, "0"));
        if (givenInterval > 0L) {
            timeUnit.convert(givenInterval, timeUnit);
            this.interval = TimeUnit.MILLISECONDS.convert(givenInterval, timeUnit);
        } else {
            this.interval = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
        }
        logger.debug("Started {} policy", (Object)this);
    }

    @Override
    public void stop() {
        this.interval = -1L;
        logger.debug("Stopped {} policy", (Object)this);
    }

    @Override
    public void apply(KieServerRegistry kieServerRegistry, KieServer kieServer) {
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl(kieServerRegistry);
        List<String> containerAliases = kieServerRegistry.getContainerAliases();
        if (containerAliases.isEmpty()) {
            logger.debug("No containers found, quiting");
            return;
        }
        for (String alias : containerAliases) {
            List<KieContainerInstanceImpl> containerInstances = kieServerRegistry.getContainersForAlias(alias);
            if (containerInstances.isEmpty() || containerInstances.size() == 1) {
                logger.debug("Containers for alias {} are already on expected level (number of containers is {})", (Object)alias, (Object)containerInstances.size());
                continue;
            }
            String latestContainerId = LatestContainerLocator.get().locateContainer(alias, containerInstances);
            HashMap report = new HashMap();
            containerInstances.stream().filter(kci -> !kci.getContainerId().equals(latestContainerId)).forEach(kci -> {
                ServiceResponse<Void> response = kieServer.disposeContainer(kci.getContainerId());
                report.put(kci.getContainerId(), response.getType().toString());
                logger.debug("Dispose of container {} completed with {} message {}", new Object[]{kci.getContainerId(), response.getType().toString(), response.getMsg()});
                if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                    controller.stopContainer(kci.getContainerId());
                }
            });
            logger.info("KeepLatestContainerOnlyPolicy applied to {} successfully (report {})", (Object)alias, report);
        }
    }

    public String toString() {
        return "KeepLatestContainerOnlyPolicy{interval=" + this.interval + " ms" + '}';
    }
}

