/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.policy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(PolicyManager.class);
    private static final ServiceLoader<Policy> policyServiceLoader = ServiceLoader.load(Policy.class);
    private Map<String, Policy> registeredPolicies = new HashMap<String, Policy>();
    private Map<String, ScheduledFuture<?>> activatedPolicies = new HashMap();
    private KieServer kieServer;
    private KieServerRegistry kieServerRegistry;
    private ScheduledExecutorService scheduledExecutorService = this.getScheduledExecutorService();

    public synchronized void start(KieServer kieServer, KieServerRegistry kieServerRegistry) {
        this.kieServer = kieServer;
        this.kieServerRegistry = kieServerRegistry;
        logger.debug("Starting policy manager...");
        policyServiceLoader.forEach(p -> {
            this.registeredPolicies.put(p.getName(), (Policy)p);
            logger.info("Registered {} policy under name {}", p, (Object)p.getName());
        });
        String toActivate = System.getProperty("org.kie.server.policy.activate");
        if (toActivate != null) {
            Object[] policies = toActivate.split(",");
            logger.debug("Following policies will be activated {}", policies);
            for (Object policy : policies) {
                String policyName = ((String)policy).trim();
                this.activatePolicy(policyName);
            }
        }
        logger.info("Policy manager started successfully, activated policies are {}", this.activatedPolicies.keySet());
    }

    public synchronized void stop() {
        logger.debug("Stopping policy manager...");
        ArrayList<String> activePolicies = new ArrayList<String>(this.activatedPolicies.keySet());
        activePolicies.forEach(policyName -> this.deactivatePolicy((String)policyName));
        this.activatedPolicies.clear();
        logger.info("Policy manager stopped successfully");
    }

    public void activatePolicy(String policyName) {
        Policy policyInstance = this.registeredPolicies.get(policyName);
        if (policyInstance == null) {
            logger.warn("Policy '{}' requested to be activated but was not registered, known policies are {}", (Object)policyName, this.registeredPolicies.keySet());
            return;
        }
        try {
            logger.debug("Starting policy {}", (Object)policyInstance);
            policyInstance.start();
            logger.debug("Policy {} successfully started", (Object)policyInstance);
            long interval = policyInstance.getInterval();
            if (interval <= 0L) {
                logger.error("Policy {} returned invalid (must be bigger than 0) interval {}, won't be activated", (Object)policyInstance, (Object)interval);
                return;
            }
            ScheduledFuture<?> future = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                logger.debug("About to apply policy {} at {}", (Object)policyInstance, (Object)new Date());
                try {
                    policyInstance.apply(this.kieServerRegistry, this.kieServer);
                    logger.debug("Policy {} applied successfully at {}", (Object)policyInstance, (Object)new Date());
                }
                catch (Throwable e) {
                    logger.error("Policy {} failed to be applied due to {}", new Object[]{policyInstance, e.getMessage(), e});
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
            logger.debug("Policy {} successfully activated, will be applied at {}", (Object)policyInstance, (Object)new Date(System.currentTimeMillis() + future.getDelay(TimeUnit.MILLISECONDS)));
            this.activatedPolicies.put(policyName, future);
        }
        catch (Exception e) {
            logger.error("Failed during activation of policy {} due to {}", new Object[]{policyInstance, e.getMessage(), e});
        }
    }

    public void deactivatePolicy(String policyName) {
        Policy policy = this.registeredPolicies.get(policyName);
        ScheduledFuture<?> future = this.activatedPolicies.remove(policyName);
        future.cancel(true);
        logger.debug("Policy {} deactivated successfully", (Object)policy);
        policy.stop();
        logger.debug("Policy {} stopped successfully", (Object)policy);
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        ScheduledExecutorService executorService = null;
        try {
            executorService = (ScheduledExecutorService)InitialContext.doLookup("java:comp/DefaultManagedScheduledExecutorService");
            logger.debug("JEE version of scheduled executor service found");
        }
        catch (Exception e) {
            executorService = Executors.newSingleThreadScheduledExecutor();
            logger.debug("Cannot find managed scheduled executor service using standard one instead", (Throwable)e);
        }
        logger.debug("Executor service to be used is {}", (Object)executorService);
        return executorService;
    }
}

