/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.marshal;

import java.util.HashSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.definition.QueryFilterSpec;
import org.kie.server.api.util.QueryFilterSpecBuilder;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.mockito.Mockito;
import org.mockito.internal.matchers.apachecommons.ReflectionEquals;
import org.skyscreamer.jsonassert.JSONAssert;
import org.xmlunit.matchers.CompareMatcher;

public class MarshallerHelperTest {
    @Test
    public void testMarshallWithoutContainer() {
        KieServerRegistry kieServerRegistryMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        MarshallerHelper helper = new MarshallerHelper(kieServerRegistryMock);
        QueryFilterSpec queryFilterSpec = new QueryFilterSpecBuilder().get();
        String marshalledQFS = helper.marshal(MarshallingFormat.JAXB.toString(), (Object)queryFilterSpec);
        String expectedMarshalledQFS = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><query-filter-spec><order-asc>false</order-asc></query-filter-spec>";
        Assert.assertThat((Object)marshalledQFS, (Matcher)CompareMatcher.isIdenticalTo((Object)expectedMarshalledQFS).ignoreWhitespace());
    }

    @Test
    public void testMarshallWithoutContainerWithExtraClasses() {
        KieServerRegistry kieServerRegistryMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        HashSet<Class<TestExtraClass>> extraClasses = new HashSet<Class<TestExtraClass>>();
        extraClasses.add(TestExtraClass.class);
        Mockito.when((Object)kieServerRegistryMock.getExtraClasses()).thenReturn(extraClasses);
        MarshallerHelper helper = new MarshallerHelper(kieServerRegistryMock);
        TestExtraClass extraClass = new TestExtraClass();
        extraClass.setBla("hallo");
        String marshalledQFS = helper.marshal(MarshallingFormat.JAXB.toString(), (Object)extraClass);
        String expectedMarshalledTEC = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><test-extra-class><bla>hallo</bla></test-extra-class>";
        Assert.assertThat((Object)marshalledQFS, (Matcher)CompareMatcher.isIdenticalTo((Object)expectedMarshalledTEC).ignoreWhitespace());
    }

    @Test
    public void testJsonMarshallWithoutWithEmptyRegistry() throws Exception {
        KieServerRegistry kieServerRegistryMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        Mockito.when((Object)kieServerRegistryMock.getExtraClasses()).thenReturn(new HashSet());
        MarshallerHelper helper = new MarshallerHelper(kieServerRegistryMock);
        QueryFilterSpec queryFilterSpec = new QueryFilterSpecBuilder().get();
        String marshalledQFS = helper.marshal(MarshallingFormat.JSON.toString(), (Object)queryFilterSpec);
        System.out.println(marshalledQFS);
        String expectedMarshalledTEC = "{\"order-by\" : null, \"order-asc\" : false, \"query-params\" : null, \"result-column-mapping\" : null}";
        JSONAssert.assertEquals((String)expectedMarshalledTEC, (String)marshalledQFS, (boolean)false);
    }

    @Test
    public void testJsonMarshallWithNullRegistry() throws Exception {
        MarshallerHelper helper = new MarshallerHelper(null);
        QueryFilterSpec queryFilterSpec = new QueryFilterSpecBuilder().get();
        String marshalledQFS = helper.marshal(MarshallingFormat.JSON.toString(), (Object)queryFilterSpec);
        System.out.println(marshalledQFS);
        String expectedMarshalledTEC = "{\"order-by\" : null, \"order-asc\" : false, \"query-params\" : null, \"result-column-mapping\" : null}";
        JSONAssert.assertEquals((String)expectedMarshalledTEC, (String)marshalledQFS, (boolean)false);
    }

    @Test
    public void testMarshallWithNullRegistry() {
        MarshallerHelper helper = new MarshallerHelper(null);
        QueryFilterSpec queryFilterSpec = new QueryFilterSpecBuilder().get();
        String marshalledQFS = helper.marshal(MarshallingFormat.JAXB.toString(), (Object)queryFilterSpec);
        String expectedMarshalledQFS = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><query-filter-spec><order-asc>false</order-asc></query-filter-spec>";
        Assert.assertThat((Object)marshalledQFS, (Matcher)CompareMatcher.isIdenticalTo((Object)expectedMarshalledQFS).ignoreWhitespace());
    }

    @Test
    public void testUnmarshallWithoutContainer() {
        KieServerRegistry kieServerRegistryMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        MarshallerHelper helper = new MarshallerHelper(kieServerRegistryMock);
        QueryFilterSpec expectedQueryFilterSpec = new QueryFilterSpecBuilder().get();
        String marshalledQFS = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><query-filter-spec><order-asc>false</order-asc></query-filter-spec>";
        QueryFilterSpec unmarshalledQFS = (QueryFilterSpec)helper.unmarshal(marshalledQFS, MarshallingFormat.JAXB.toString(), QueryFilterSpec.class);
        Assert.assertThat((Object)expectedQueryFilterSpec, (Matcher)new ReflectionEquals((Object)unmarshalledQFS, new String[0]));
    }

    @Test
    public void testUnmarshallWithoutContainerWithExtraClasses() {
        KieServerRegistry kieServerRegistryMock = (KieServerRegistry)Mockito.mock(KieServerRegistry.class);
        HashSet<Class<TestExtraClass>> extraClasses = new HashSet<Class<TestExtraClass>>();
        extraClasses.add(TestExtraClass.class);
        Mockito.when((Object)kieServerRegistryMock.getExtraClasses()).thenReturn(extraClasses);
        MarshallerHelper helper = new MarshallerHelper(kieServerRegistryMock);
        TestExtraClass expectedExtraClass = new TestExtraClass();
        expectedExtraClass.setBla("hallo");
        String marshalledTEC = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><test-extra-class><bla>hallo</bla></test-extra-class>";
        TestExtraClass unmarshalledTEC = (TestExtraClass)helper.unmarshal(marshalledTEC, MarshallingFormat.JAXB.toString(), TestExtraClass.class);
        Assert.assertEquals((Object)expectedExtraClass, (Object)unmarshalledTEC);
    }

    @Test
    public void testUnmarshallWithoutNullRegistry() {
        MarshallerHelper helper = new MarshallerHelper(null);
        QueryFilterSpec expectedQueryFilterSpec = new QueryFilterSpecBuilder().get();
        String marshalledQFS = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><query-filter-spec><order-asc>false</order-asc></query-filter-spec>";
        QueryFilterSpec unmarshalledQFS = (QueryFilterSpec)helper.unmarshal(marshalledQFS, MarshallingFormat.JAXB.toString(), QueryFilterSpec.class);
        Assert.assertThat((Object)expectedQueryFilterSpec, (Matcher)new ReflectionEquals((Object)unmarshalledQFS, new String[0]));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="test-extra-class")
    public static class TestExtraClass {
        @XmlElement(name="bla")
        private String bla;

        public String getBla() {
            return this.bla;
        }

        public void setBla(String bla) {
            this.bla = bla;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            TestExtraClass rhs = (TestExtraClass)obj;
            return new EqualsBuilder().append((Object)this.bla, (Object)rhs.bla).isEquals();
        }
    }
}

