/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.api.KieContainerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatestContainerLocator
implements ContainerLocator {
    private static final Logger logger = LoggerFactory.getLogger(LatestContainerLocator.class);
    private static LatestContainerLocator INSTANCE = new LatestContainerLocator();

    public static LatestContainerLocator get() {
        return INSTANCE;
    }

    @Override
    public String locateContainer(String alias, List<? extends KieContainerInstance> containerInstances) {
        if (containerInstances.isEmpty()) {
            return alias;
        }
        logger.debug("Searching for latest container for alias {} within available containers {}", (Object)alias, containerInstances);
        ArrayList comparableVersions = new ArrayList();
        HashMap versionToIdentifier = new HashMap();
        containerInstances.forEach(c -> {
            if (c.getStatus().equals((Object)KieContainerStatus.STARTED)) {
                comparableVersions.add(new KieRepositoryImpl.ComparableVersion(c.getKieContainer().getReleaseId().getVersion()));
                versionToIdentifier.put(c.getKieContainer().getReleaseId().getVersion(), c.getContainerId());
            }
        });
        KieRepositoryImpl.ComparableVersion latest = (KieRepositoryImpl.ComparableVersion)Collections.max(comparableVersions);
        logger.debug("Latest version for alias {} is {}", (Object)alias, comparableVersions);
        return (String)versionToIdentifier.get(latest.toString());
    }
}

