/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.concurrent.TimeUnit;
import org.drools.core.command.runtime.AdvanceSessionTimeCommand;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.GetSessionTimeCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.GetFactHandlesCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.GetObjectsCommand;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.ModifyCommand;
import org.drools.core.command.runtime.rule.QueryCommand;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;

public class CommandsMarshallingTest {
    private Marshaller marshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)Thread.currentThread().getContextClassLoader());

    @Test
    public void testMarshallInsertObjectCommand() {
        String xmlCommand = "<insert>\n  <string>String value</string>\n</insert>";
        InsertObjectCommand command = (InsertObjectCommand)this.marshaller.unmarshall(xmlCommand, InsertObjectCommand.class);
        Assert.assertEquals((Object)"String value", (Object)command.getObject().toString());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallModifyCommand() {
        String xmlCommand = "<modify fact-handle=\"0:234:345:456:567:789\">\n  <set accessor=\"age\" value=\"30\"/>\n</modify>";
        ModifyCommand command = (ModifyCommand)this.marshaller.unmarshall(xmlCommand, ModifyCommand.class);
        Assert.assertEquals((long)1L, (long)command.getSetters().size());
        Assert.assertEquals((Object)"<modify fact-handle=\"0:234:345:456:567:789:NON_TRAIT:null\">\n  <set accessor=\"age\" value=\"30\"/>\n</modify>", (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallGetObjectCommand() {
        String xmlCommand = "<get-object fact-handle=\"0:234:345:456:567:789\" out-identifier=\"test\"/>";
        GetObjectCommand command = (GetObjectCommand)this.marshaller.unmarshall(xmlCommand, GetObjectCommand.class);
        Assert.assertEquals((Object)"test", (Object)command.getOutIdentifier());
        Assert.assertEquals((Object)"<get-object fact-handle=\"0:234:345:456:567:789:NON_TRAIT:null\" out-identifier=\"test\"/>", (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallInsertElementsCommand() {
        String xmlCommand = "<insert-elements>\n  <string>test1</string>\n  <string>test2</string>\n</insert-elements>";
        InsertElementsCommand command = (InsertElementsCommand)this.marshaller.unmarshall(xmlCommand, InsertElementsCommand.class);
        Assert.assertEquals((long)2L, (long)command.getObjects().size());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallFireAllRulesCommand() {
        String xmlCommand = "<fire-all-rules max=\"10\" out-identifier=\"result\"/>";
        FireAllRulesCommand command = (FireAllRulesCommand)this.marshaller.unmarshall(xmlCommand, FireAllRulesCommand.class);
        Assert.assertEquals((long)10L, (long)command.getMax());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallStartProcessCommand() {
        String xmlCommand = "<start-process processId=\"org.drools.task.processOne\" out-identifier=\"id\"/>";
        StartProcessCommand command = (StartProcessCommand)this.marshaller.unmarshall(xmlCommand, StartProcessCommand.class);
        Assert.assertEquals((Object)"org.drools.task.processOne", (Object)command.getProcessId());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallQueryCommand() {
        String xmlCommand = "<query out-identifier=\"persons-out\" name=\"persons\"/>";
        QueryCommand command = (QueryCommand)this.marshaller.unmarshall(xmlCommand, QueryCommand.class);
        Assert.assertEquals((Object)"persons", (Object)command.getName());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallSetGlobalCommand() {
        String xmlCommand = "<set-global identifier=\"helper\" out-identifier=\"output\">\n  <list/>\n</set-global>";
        SetGlobalCommand command = (SetGlobalCommand)this.marshaller.unmarshall(xmlCommand, SetGlobalCommand.class);
        Assert.assertEquals((Object)"helper", (Object)command.getIdentifier());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallGetGlobalCommand() {
        String xmlCommand = "<get-global identifier=\"helper\" out-identifier=\"helperOutput\"/>";
        GetGlobalCommand command = (GetGlobalCommand)this.marshaller.unmarshall(xmlCommand, GetGlobalCommand.class);
        Assert.assertEquals((Object)"helper", (Object)command.getIdentifier());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallGetObjectsCommand() {
        String xmlCommand = "<get-objects out-identifier=\"objects\"/>";
        GetObjectsCommand command = (GetObjectsCommand)this.marshaller.unmarshall(xmlCommand, GetObjectsCommand.class);
        Assert.assertEquals((Object)"objects", (Object)command.getOutIdentifier());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    @Ignore(value="Set focus command not yet supported")
    public void testMarshallAgendaGroupSetFocusCommand() {
        String xmlCommand = "<agenda-group-set-focus name=\"my-agenda-group\"/>";
        AgendaGroupSetFocusCommand command = (AgendaGroupSetFocusCommand)this.marshaller.unmarshall(xmlCommand, AgendaGroupSetFocusCommand.class);
        Assert.assertEquals((Object)"my-agenda-group", (Object)command.getName());
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallDeleteCommand() {
        String xmlCommand = "<delete fact-handle=\"0:234:345:456:567:789\"/>";
        DeleteCommand command = (DeleteCommand)this.marshaller.unmarshall(xmlCommand, DeleteCommand.class);
        Assert.assertEquals((Object)"<delete fact-handle=\"0:234:345:456:567:789:NON_TRAIT:null\"/>", (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallGetFactHandlesCommand() {
        String xmlCommand = "<get-fact-handles/>";
        GetFactHandlesCommand command = (GetFactHandlesCommand)this.marshaller.unmarshall(xmlCommand, GetFactHandlesCommand.class);
        Assert.assertEquals((Object)"<get-fact-handles disconnected=\"false\"/>", (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallGetSessionTimeCommand() {
        String xmlCommand = "<get-session-time out-identifier=\"session-currenttime\"/>";
        GetSessionTimeCommand command = (GetSessionTimeCommand)this.marshaller.unmarshall(xmlCommand, GetSessionTimeCommand.class);
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }

    @Test
    public void testMarshallAdvanceSessionTimeCommand() {
        String xmlCommand = "<advance-session-time out-identifier=\"session-advancecurrenttime\" amount=\"2\" unit=\"DAYS\"/>";
        AdvanceSessionTimeCommand command = (AdvanceSessionTimeCommand)this.marshaller.unmarshall(xmlCommand, AdvanceSessionTimeCommand.class);
        Assert.assertEquals((long)2L, (long)command.getAmount());
        Assert.assertEquals((Object)((Object)TimeUnit.DAYS), (Object)((Object)command.getUnit()));
        Assert.assertEquals((Object)xmlCommand, (Object)this.marshaller.marshall((Object)command));
    }
}

