/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.policy;

import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.policy.KeepLatestContainerOnlyPolicy;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KeepLatestContainerOnlyPolicyTest {
    private static final String CONTAINER_ONE = "container1";
    private static final String CONTAINER_TWO = "container2";
    private KieServer kieServer;
    private InternalKieContainer kieContainerOne;
    private InternalKieContainer kieContainerTwo;

    @Before
    public void setUp() {
        this.kieServer = (KieServer)Mockito.mock(KieServer.class);
        Mockito.when((Object)this.kieServer.disposeContainer(Matchers.anyString())).thenReturn((Object)new ServiceResponse(ServiceResponse.ResponseType.NO_RESPONSE, "Success."));
        this.kieContainerOne = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)this.kieContainerOne.getReleaseId()).thenReturn((Object)new ReleaseId("org.kie", "container", "1.0"));
        Mockito.when((Object)this.kieContainerOne.getContainerReleaseId()).thenReturn((Object)new ReleaseId("org.kie", "container", "1.0"));
        this.kieContainerTwo = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)this.kieContainerTwo.getReleaseId()).thenReturn((Object)new ReleaseId("org.kie", "container", "2.0"));
        Mockito.when((Object)this.kieContainerTwo.getContainerReleaseId()).thenReturn((Object)new ReleaseId("org.kie", "container", "2.0"));
    }

    @Test
    public void testDisposeOldContainer() {
        KieServerRegistryImpl kieServerRegistry = new KieServerRegistryImpl();
        KieContainerInstanceImpl kieContainerInstance = new KieContainerInstanceImpl(CONTAINER_ONE, KieContainerStatus.STARTED, this.kieContainerOne);
        kieServerRegistry.registerContainer(CONTAINER_ONE, kieContainerInstance);
        kieContainerInstance = new KieContainerInstanceImpl(CONTAINER_TWO, KieContainerStatus.STARTED, this.kieContainerTwo);
        kieServerRegistry.registerContainer(CONTAINER_TWO, kieContainerInstance);
        KeepLatestContainerOnlyPolicy policy = new KeepLatestContainerOnlyPolicy();
        policy.apply((KieServerRegistry)kieServerRegistry, this.kieServer);
        ((KieServer)Mockito.verify((Object)this.kieServer)).disposeContainer(CONTAINER_ONE);
    }

    @Test
    public void testDoNotDisposeNewerCreatedContainer() {
        KieServerRegistryImpl kieServerRegistry = new KieServerRegistryImpl();
        KieContainerInstanceImpl kieContainerInstance = new KieContainerInstanceImpl(CONTAINER_ONE, KieContainerStatus.STARTED, this.kieContainerOne);
        kieServerRegistry.registerContainer(CONTAINER_ONE, kieContainerInstance);
        kieContainerInstance = new KieContainerInstanceImpl(CONTAINER_TWO, KieContainerStatus.CREATING, this.kieContainerTwo);
        kieServerRegistry.registerContainer(CONTAINER_TWO, kieContainerInstance);
        KeepLatestContainerOnlyPolicy policy = new KeepLatestContainerOnlyPolicy();
        policy.apply((KieServerRegistry)kieServerRegistry, this.kieServer);
        ((KieServer)Mockito.verify((Object)this.kieServer, (VerificationMode)Mockito.never())).disposeContainer(Matchers.anyString());
    }
}

