/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.GetContainerInfoCommand;
import org.kie.server.api.commands.GetReleaseIdCommand;
import org.kie.server.api.commands.GetScannerInfoCommand;
import org.kie.server.api.commands.GetServerInfoCommand;
import org.kie.server.api.commands.GetServerStateCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerCommandServiceImpl
implements KieContainerCommandService<ExecutionResults> {
    protected static final Pattern LOOKUP = Pattern.compile("[\"']?lookup[\"']?\\s*[:=]\\s*[\"']([^\"']+)[\"']");
    private static final Logger logger = LoggerFactory.getLogger(KieContainerCommandServiceImpl.class);
    protected KieServerImpl kieServer;
    protected final KieServerRegistry context;

    public KieContainerCommandServiceImpl(KieServerImpl kieServer, KieServerRegistry context) {
        this.kieServer = kieServer;
        this.context = context;
    }

    @Override
    public ServiceResponse<ExecutionResults> callContainer(String containerId, String payload, MarshallingFormat marshallingFormat, String classType) {
        return this.callContainer(containerId, payload, marshallingFormat, classType, false);
    }

    protected ServiceResponse<ExecutionResults> callContainer(String containerId, String payload, MarshallingFormat marshallingFormat, String classType, boolean marshallResponse) {
        if (payload == null) {
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ". Empty payload. ");
        }
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            if (kci != null && kci.getKieContainer() != null) {
                String sessionId = null;
                Matcher m = LOOKUP.matcher(payload);
                if (m.find()) {
                    sessionId = m.group(1);
                }
                Object ks = null;
                ks = sessionId != null ? this.context.getKieSessionLookupManager().lookup(sessionId, kci, this.context) : kci.getKieContainer().getKieSession();
                if (ks != null) {
                    Command cmd;
                    Class type = BatchExecutionCommandImpl.class;
                    if (classType != null && !classType.isEmpty()) {
                        type = kci.getKieContainer().getClassLoader().loadClass(classType);
                    }
                    if ((cmd = (Command)kci.getMarshaller(marshallingFormat).unmarshall(payload, type)) == null) {
                        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Body of in message not of the expected type '" + Command.class.getName() + "'");
                    }
                    if (!(cmd instanceof BatchExecutionCommandImpl)) {
                        cmd = new BatchExecutionCommandImpl(Arrays.asList((ExecutableCommand)cmd));
                    }
                    ExecutionResults results = (ExecutionResults)ks.execute((Command)((BatchExecutionCommandImpl)cmd));
                    if (marshallResponse) {
                        Marshaller marshaller = kci.getMarshaller(marshallingFormat);
                        String result = marshaller.marshall((Object)results);
                        return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully called.", (Object)result);
                    }
                    return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully called.", (Object)results);
                }
                return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Session '" + sessionId + "' not found on container '" + containerId + "'.");
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Container " + containerId + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error calling container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public ServiceResponsesList executeScript(CommandScript commands, MarshallingFormat marshallingFormat, String classType) {
        ArrayList responses = new ArrayList();
        if (commands != null) {
            for (KieServerCommand command : commands.getCommands()) {
                ServiceResponse<?> forbidden;
                if (command instanceof CreateContainerCommand) {
                    forbidden = this.kieServer.checkAccessability();
                    if (forbidden != null) {
                        logger.warn("Kie Server management api is disabled, skiping command execution {}", (Object)command);
                        responses.add(forbidden);
                        continue;
                    }
                    responses.add(this.kieServer.createContainer(((CreateContainerCommand)command).getContainer().getContainerId(), ((CreateContainerCommand)command).getContainer()));
                    continue;
                }
                if (command instanceof GetServerInfoCommand) {
                    responses.add(this.kieServer.getInfo());
                    continue;
                }
                if (command instanceof ListContainersCommand) {
                    responses.add(this.kieServer.listContainers(((ListContainersCommand)command).getKieContainerResourceFilter()));
                    continue;
                }
                if (command instanceof CallContainerCommand) {
                    ServiceResponse<ExecutionResults> response = this.callContainer(((CallContainerCommand)command).getContainerId(), ((CallContainerCommand)command).getPayload(), marshallingFormat, classType, true);
                    responses.add(response);
                    continue;
                }
                if (command instanceof DisposeContainerCommand) {
                    forbidden = this.kieServer.checkAccessability();
                    if (forbidden != null) {
                        logger.warn("Kie Server management api is disabled, skiping command execution {}", (Object)command);
                        responses.add(forbidden);
                        continue;
                    }
                    responses.add(this.kieServer.disposeContainer(((DisposeContainerCommand)command).getContainerId()));
                    continue;
                }
                if (command instanceof GetContainerInfoCommand) {
                    responses.add(this.kieServer.getContainerInfo(((GetContainerInfoCommand)command).getContainerId()));
                    continue;
                }
                if (command instanceof GetScannerInfoCommand) {
                    responses.add(this.kieServer.getScannerInfo(((GetScannerInfoCommand)command).getContainerId()));
                    continue;
                }
                if (command instanceof UpdateScannerCommand) {
                    forbidden = this.kieServer.checkAccessability();
                    if (forbidden != null) {
                        logger.warn("Kie Server management api is disabled, skiping command execution {}", (Object)command);
                        responses.add(forbidden);
                        continue;
                    }
                    responses.add(this.kieServer.updateScanner(((UpdateScannerCommand)command).getContainerId(), ((UpdateScannerCommand)command).getScanner()));
                    continue;
                }
                if (command instanceof GetReleaseIdCommand) {
                    responses.add(this.kieServer.getContainerReleaseId(((GetReleaseIdCommand)command).getContainerId()));
                    continue;
                }
                if (command instanceof UpdateReleaseIdCommand) {
                    forbidden = this.kieServer.checkAccessability();
                    if (forbidden != null) {
                        logger.warn("Kie Server management api is disabled, skiping command execution {}", (Object)command);
                        responses.add(forbidden);
                        continue;
                    }
                    responses.add(this.kieServer.updateContainerReleaseId(((UpdateReleaseIdCommand)command).getContainerId(), ((UpdateReleaseIdCommand)command).getReleaseId()));
                    continue;
                }
                if (!(command instanceof GetServerStateCommand)) continue;
                responses.add(this.kieServer.getServerState());
            }
        }
        return new ServiceResponsesList(responses);
    }
}

