/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ControllerBasedStartupStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupStrategyProvider {
    private static final Logger logger = LoggerFactory.getLogger(StartupStrategyProvider.class);
    private static final ServiceLoader<StartupStrategy> strategies = ServiceLoader.load(StartupStrategy.class);
    private static StartupStrategyProvider INSTANCE = new StartupStrategyProvider();
    private Map<String, StartupStrategy> foundStrategies = new HashMap<String, StartupStrategy>();
    private String strategyName = System.getProperty("org.kie.server.startup.strategy", ControllerBasedStartupStrategy.class.getSimpleName());

    private StartupStrategyProvider() {
        strategies.forEach(s -> {
            this.foundStrategies.put(s.getClass().getSimpleName(), (StartupStrategy)s);
            logger.debug("Discovered '{}' startup strategy and registered under '{}'", s, (Object)s.getClass().getSimpleName());
        });
        this.foundStrategies.put(ControllerBasedStartupStrategy.class.getSimpleName(), new ControllerBasedStartupStrategy());
    }

    public StartupStrategy getStrategy() {
        StartupStrategy strategy = this.foundStrategies.get(this.strategyName);
        if (strategy == null) {
            throw new IllegalStateException("No startup strategy found under name " + this.strategyName);
        }
        return strategy;
    }

    public static StartupStrategyProvider get() {
        return INSTANCE;
    }

    public static void clear() {
        INSTANCE = new StartupStrategyProvider();
    }
}

