/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.core.impl.InternalKieContainer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.builder.KieScanner;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KieServerImplOperationTest {
    private static final File REPOSITORY_DIR = new File("target/repository-dir");
    private static final String KIE_SERVER_ID = "kie-server-impl-test";
    private KieServerImpl kieServer;
    private String origServerId = null;

    @Before
    public void setupKieServerImpl() throws Exception {
        this.origServerId = KieServerEnvironment.getServerId();
        System.setProperty("org.kie.server.id", KIE_SERVER_ID);
        KieServerEnvironment.setServerId((String)KIE_SERVER_ID);
        FileUtils.deleteDirectory((File)REPOSITORY_DIR);
        FileUtils.forceMkdir((File)REPOSITORY_DIR);
        this.kieServer = new KieServerImpl((KieServerStateRepository)new KieServerStateFileRepository(REPOSITORY_DIR));
        this.kieServer.init();
    }

    @After
    public void cleanUp() {
        if (this.kieServer != null) {
            this.kieServer.destroy();
        }
        KieServerEnvironment.setServerId((String)this.origServerId);
    }

    @Test
    public void testDisposeContainerWithScanner() {
        InternalKieScanner mockedScanner = (InternalKieScanner)Mockito.mock(InternalKieScanner.class);
        Mockito.when((Object)mockedScanner.getStatus()).thenReturn((Object)KieScanner.Status.RUNNING);
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)new KieContainerResource("id", new ReleaseId("g", "a", "v")));
        Mockito.when((Object)kieContainerInstance.getScanner()).thenReturn((Object)mockedScanner);
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        this.kieServer.disposeContainer("id");
        ((KieContainerInstanceImpl)Mockito.verify((Object)kieContainerInstance, (VerificationMode)Mockito.times((int)1))).stopScanner();
    }

    @Test
    public void testDisposeContainerWithNoScanner() {
        InternalKieContainer mockedKieContainer = (InternalKieContainer)Mockito.mock(InternalKieContainer.class);
        Mockito.when((Object)mockedKieContainer.getReleaseId()).thenReturn((Object)new ReleaseId("g", "a", "v"));
        KieContainerInstanceImpl kieContainerInstance = (KieContainerInstanceImpl)Mockito.mock(KieContainerInstanceImpl.class);
        Mockito.when((Object)kieContainerInstance.getContainerId()).thenReturn((Object)"id");
        Mockito.when((Object)kieContainerInstance.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        Mockito.when((Object)kieContainerInstance.getKieContainer()).thenReturn((Object)mockedKieContainer);
        Mockito.when((Object)kieContainerInstance.getResource()).thenReturn((Object)new KieContainerResource("id", new ReleaseId("g", "a", "v")));
        this.kieServer.getServerRegistry().registerContainer("id", kieContainerInstance);
        this.kieServer.disposeContainer("id");
        ((KieContainerInstanceImpl)Mockito.verify((Object)kieContainerInstance, (VerificationMode)Mockito.times((int)0))).stopScanner();
    }
}

